function im=FFTwaveletsynthesis2D(w,FFTsynthesisfilters,J);
% 	Usage: w=FFTwaveletanalysis2D(im,FFTanalysisfilters,J)
%
%   FFT-based implementation of the inverse wavelet transform (see ref. [2]). It computes the inverse  
%   wavelet transform of an image "w" using a Fourier method. It uses periodic boundary conditions.   
%   The image must be square and its size be a power of two; the frequency responses (same length as  
%   the size of the image) of the analysis filters are specified in the two rows of FFTsynthesisfilters.
%
% 	Input:
% 	w = image of size 2^N x 2^N=length of FFTanalysisfilters in the usual representation; 
%	    e.g., in the case of one iteration (J=1) w is made of four quadrants 
%	    [LowLow LowHigh ; HighLow HighHigh], the top left being the low-pass filtered image. 
% 	J = depth of the decomposition, i.e., 3J+1 wavelet bands in two dimensions 
% 	FFTanalysisfilters = [lowpassfilter;highpassfilter]
% 	
% 	Output:
% 	im = image, of same size as w
% 	
% 	See also FFTWAVELETANALYSIS2D, FFTFRACTSPLINEFILTERS,WEXTRACT2D.
% 	
% 	Author: Manuela Feilner and Thierry Blu, October 1999
% 	Biomedical Imaging Group, EPFL, Lausanne, Switzerland.
% 	
% 	This software is downloadable at http://www.ee.cuhk.edu.hk/~tblu/demos/
% 	
% 	References:
% 	[1] Unser, M. & Blu, T.,"Fractional Splines and Wavelets", SIAM Review, Vol. 42 (1), pp. 43-67, March 2000. 
% 	[2] Blu, T. & Unser, M.,"The Fractional Spline Wavelet Transform: Definition and Implementation", Proc. IEEE International 
%       Conference on Acoustics, Speech, and Signal Processing (ICASSP'00), Istanbul, Turkey, Vol. {I}, pp. 512-515, June 5--9, 2000.  
%   [3] Blu, T. & Unser, M.,"A Complete Family of Scaling Functions: The $($-Fractional Splines", Proc. IEEE International 
%       Conference on Acoustics, Speech, and Signal Processing (ICASSP'03), Hong Kong, China, Vol. {VI}, pp. 421-424, April 6--10, 2003. 
%
%	Demo at http://bigwww.epfl.ch/demo/jfractsplinewavelet/

M=length(w);
if M~=2^round(log(M)/log(2))
	disp(' ')
	disp('The size of the input signal must be a power of two!')
	disp(' ')
	im=[];
	return
end
if length(FFTsynthesisfilters)~=M
	disp(' ')
	disp('The size of the input signal and of the filters must match!')
	disp(' ')
	w=[];
	return
end


%
% Reconstruction of the signal from its
% bandpass components
%

G=conj(FFTsynthesisfilters(1,:));
H=conj(FFTsynthesisfilters(2,:));

M=M/2^J;

for j=J:-1:1,
	H1=H(1:2^(j-1):length(H));
	G1=G(1:2^(j-1):length(G));
	im=w(1:2*M,1:2*M);

	for i=1:2*M,
		Y=fft(reshape(im(1:M,i),1,M),M);
		z=reshape(im((M+1):2*M,i),1,M);
		Z=fft(z,M);
		Y0=G1(1:M).*Y+H1(1:M).*Z;
		Y1=G1(M+(1:M)).*Y+H1(M+(1:M)).*Z;
		Y=[Y0 Y1];
		im(:,i)=reshape(ifft(Y,2*M),2*M,1);
	end;	
	for i=1:2*M,
		Y=fft(im(i,1:M),M);
		z=im(i,(M+1):2*M);
		Z=fft(z,M);
		Y0=G1(1:M).*Y+H1(1:M).*Z;
		Y1=G1(M+(1:M)).*Y+H1(M+(1:M)).*Z;
		Y=[Y0 Y1];
		im(i,:)=ifft(Y,2*M);

	end;
	M=2*M;
	w(1:M,1:M)=im;
end;
im=real(w);
