
function h = non_symmetric_gaussian_kernel ( m, n,  theta,    sigma_1, sigma_2, s )
h = ones(m,n); theta = -theta;
center_x = (m+1)/2; center_y = (n+1)/2;

for i = 1:m
    for j = 1:n
        i_x = i-center_x; j_y = j-center_y; 
        h(i,j) = exp(- (i_x*cos(theta)-j_y*sin(theta) )^2/(1*s*sigma_1^2) - ( (i_x*sin(theta)+j_y*cos(theta) )^2/(1*s*sigma_2^2) ) );
    end
end
h = h./sum(h(:));

return;