%This program implements the single-frame complex wave retrieval algorithm in the paper 
%G. Luo, Y. He, X. Shu, R. Zhou, and T. Blu, "Complex Wave and Phase Retrieval
%from A Single Off-Axis Interferogram". JOSA A. Accepted (2022).

clear;clc;close all;
addpath('Utilities/');
addpath('Functions/');
addpath('images/');


% Procedures:
% 1, load ground-truth data without phase distortion
% 2, generate distorted phase and input data
% 3, apply phase restoration

% varibles in data generation:
%   'input'  - complex-valued data input
%   'ph_gt'  - ground-truth phase without distortion

% varibles of output:
%   'ph_our' - restored phase by our method

clear; clc; close all;
%% load ground-truth data without phase distortion
load('fig10data.mat');
[M,N] = size(A);
ph_gt = (angle(A));
ph_gt = ph_gt - median(ph_gt(:));
A = abs(A).*exp(1j*ph_gt);
%% distorted phase generation
rng(15);
w_A = [0.0*2*pi/M,-0.0*2*pi/N,(10*[ 0.55e-1*(randn(1,3)-0.0),-4.5e-1*(randn(1,5)-0.0)])];
deg = 3;
[fitmat] = aux_2D_ChebyshevPolynomial(M,N,deg);
phDistortion = exp(1j* reshape(fitmat*w_A',M,N) );
ph_abe = reshape(fitmat*w_A',M,N);
%% raw phase
rng(3);
noise_psnr = 50;
ph_wrap0 = addnoise(ph_gt,noise_psnr);
ph_wrap = mod(pi+ph_wrap0 + ph_abe,2*pi) - pi;
ph_gt = ph_wrap0;% update ground-truth phase with noise

%% apply phase restoration
%%%%%%%%%%%%%%%%%%%%%%%%Our restoration%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
input = exp(1j*ph_wrap);
tic;
[~,q] = qangle(input,fitmat);
phi = reshape(fitmat*q,[M,N]);
ph_our = angle( ( input.*exp(-1j*phi) ) );
toc;
%% display
%mask sure results by all methods have the same median value as that of the
%ground truth
ph_our = ph_our + median(ph_gt(:))-median(ph_our(:));
PSNR(ph_our,ph_gt)

figure,
m = 2*2;
row = 2;
margin = 0.2;
set(gcf,'Position',[600,200,800,800]);
caxis([-pi,pi]);
n = 1;
subplot('Position',[(mod(n-1,row))/row+ margin/m^2, 1-(ceil(n/row))/row+ margin/m^2, 1/(row+margin), 1/(row+margin)])
imshow(angle(input),[]);title('Raw wrapped phase');colorbar
caxis([-pi,pi]);
n = 2;
subplot('Position',[(mod(n-1,row))/row+ margin/m^2, 1-(ceil(n/row))/row+ margin/m^2, 1/(row+margin), 1/(row+margin)])
imshow(angle(exp(1j*ph_abe)),[]);title('Wrapped distorted phase');colorbar
n = 3;
subplot('Position',[(mod(n-1,row))/row + margin/m^2, 1-(ceil(n/row))/row+ margin/m^2, 1/(row+margin), 1/(row+margin)])
imshow(ph_gt,[]);title('Ground-truth (no distortion)');colorbar
caxis([-pi,pi]);
n = 4;
subplot('Position',[(mod(n-1,row))/row + margin/m^2, 1-(ceil(n/row))/row+ margin/m^2, 1/(row+margin), 1/(row+margin)])
imshow(ph_our,[]);title('Restored phase by our method');colorbar
caxis([-pi,pi]);

