function [fitmat] = aux_2D_ChebyshevPolynomial(M,N,deg)
%FUNCTION : return 2D Chebyshev Polynomial of degree 'deg'
% INPUT:    
%        x, y   - 2D rectangular coordinates
% OUTPUT:   
%        fitmat - Polynomial basis functions
%
% AUTHOR : Gang Luo and Thierry Blu
% DATE   : November 2022
% CONTACT: Gang Luo (luogang@link.cuhk.edu.hk), The Chinese University of Hong Kong.

x=1:M;x=(x-(M+1)/2)/(M-1);x=repmat(x',[1,N]);
y=1:N;y=(y-(N+1)/2)/(N-1);y=repmat(y,[M,1]);
t=acos(2*x);u=acos(2*y);
fitmat=zeros(M*N,(deg+2)*(deg+1)/2);
n=1;
for k=0:deg
    for l=0:(deg-k)
        fitmat(:,n)=cos(k*t(:)).*cos(l*u(:));
        n=n+1;
    end
end
