/********************************************************************/	
/*   																*/
/*			Audio Recorder program for CUHK ARM board 2012	 		*/
/*				(08/2015)											*/
/*														            */
/********************************************************************/
/*                                                                  */
/*			ARM CPU: Philips LPC2138								*/
/*			Crystal clock: 11.0592 MHz								*/
/*			Serial port baudrate: 57600								*/
/*			Programming tool: KEIL uVision3 RealView for ARM 		*/			
/*																	*/
/********************************************************************/
#include <lpc213x.h>

extern void init_timer(void);

#define TEST_PIN	0x00010000	//set p1.16 as Test pin  

#define NEWLINE sendchar(0x0a); sendchar(0x0d)

#define REC_SIZE	26000

//define global variables
long timeval,DA;

//int lcur,rcur,lold,rold,lcount,rcount;
unsigned char dat[REC_SIZE],finish,play;

//===============================
void  Init_Serial_A(void) {  
	U0LCR = 0x83;	//8 bit length ,DLAB=1	           
   	U0DLL =  ;	//Pclk/(16*baudrate)=(11059200 x 5)/(4 x 16 x 57600);
   	U0DLM =  ;
   	U0LCR = 0x03;    //DLAB=0
}

char getchar(void) {
	volatile char ch = '0';

  	while ((  )==0) // wait until  receive a byte
    ;
  	ch = ;         // receive character

  	return ch;
}

void sendchar(char ch) {
	while( (   )==0 );
    
 	  = ch;                     // Transmit next character
}

int  print(char *p) { 
	while(*p!='\0') {
      sendchar(*p++);
   }
   return(0);
}

void putint(int count) { 
	//sendchar('0' + count/10000);
	//sendchar('0' + (count/1000) % 10);
	sendchar('0' + (count/100) % 10);
	sendchar('0' + (count/10) % 10);
	sendchar('0' + count % 10);
}

unsigned char read_sensor(int channel)
{
	int temp;
         
	AD0CR=0x1<<channel;	//Set channel SEL field
	AD0CR|=0x1200200;	//Start conversion now; ADC is operational;
						//11 clocks/ 10 bits; Software conversion mode;
						//CLKDIV = 2; ADclk = Pclk/(CLKDIV+1)
						//ADclk = (11059200 x 5)/(4 x 3) = 4.608MHz

	while(((temp=AD0DR)&0x80000000)==0);	//check DONE flag
	//temp>>=6;	//ADDR p6-p15 = RESULT
	//temp&=0x3ff;//10 bits result
	temp>>=8;	//ADDR p6-p15 = RESULT
	temp&=0xff;//8 bits result

	//return (temp*33);	//return 0-3V value precision is 256 
	return (temp);	//return 0-3V value precision is 256 
}

int  main(void)
{

 char cin;
 long i;

 PINSEL0 = 0x00000005;		// set p0.0 to TXD0, p0.1 to RXD0 and the rest to GPIO	
 PINSEL1 = 0x00400000;		// set p0.27 to ad0.0 and the rest to GPIO
 PINSEL1 |= 0x00080000;		// set p0.25 to AOUT (DAC)
 
 Init_Serial_A();		// Init COM port
 init_timer();			// Init TIMER 0
 
 NEWLINE;
 print("======================================================================="); NEWLINE;
 print("*                                                                     *"); NEWLINE;
 print("*         CUHK Computer Science and Engineering Department            *"); NEWLINE;
 print("*         LPC2138 ARM Board (2015) Audio Recorder                     *"); NEWLINE;
 print("*                                                                     *"); NEWLINE;
 print("======================================================================="); NEWLINE;
 print("*                                                                     *"); NEWLINE;
 print("*  r - Start record;              p - Play recorded audio             *"); NEWLINE;
 print("*                                                                     *"); NEWLINE;
 print("*  d - Dump recorded audio data;                                      *"); NEWLINE;
 print("*                                                                     *"); NEWLINE;
 print("======================================================================="); NEWLINE;
 NEWLINE;
 
 IO1DIR|=TEST_PIN;       	// p1.16 as Outputs


 while(1) {
 	
	cin=getchar();

	if (cin=='r') {
		print("Start recording ....");
		NEWLINE;
		finish = 0;
		timeval = 0;
		while(finish==0) {}
		print("Recording finish");
		NEWLINE;
	}
	else if (cin=='p') {
		print("Start playing ....");
		NEWLINE;
		play = 0;
		timeval = 0;
		while(play==0) {}
		print("Play finish");
		NEWLINE;

	}
	else if (cin=='d') {
		for (i=0;i<REC_SIZE;i++) {
			putint(dat[i]);
			NEWLINE;
		}	
	}
 	}
 }
 
void __irq  IRQ_Exception()
{

	// Audio recording
  	if((finish==0)&&(timeval<REC_SIZE)) {
		dat[timeval] = read_sensor(0);
		timeval++;
	}
	if((finish==0)&&(timeval>=REC_SIZE)) finish = 1; 

	// Audio playing
	if((play==0)&&(timeval<REC_SIZE)) {
		DA = dat[timeval];
		DA <<=8;
		DA &= 0xff00;
		DACR = DA;
		timeval++;
	}
	if((play==0)&&(timeval>=REC_SIZE)) play = 1;  
	
    T0IR = 1;                              	// Clear interrupt flag
    VICVectAddr = 0;                       	// Acknowledge Interrupt
}

/* Setup the Timer Counter 0 Interrupt */
void init_timer (void) {
	          ;								// set prescaler to 0
	//T0MR0 =13824;							// set interrupt interval to 1mS
	//T0MR0 =1728;							// set interrupt (sampling rate) to 8KHz
	//T0MR0 =6912;							// set interrupt (sampling rate) to 2KHz
	T0MR0 =3456;							// set interrupt (sampling rate) to 4KHz
											// Pclk/4KHz = (11059200 x 5)/(4 x 4000)
          ;                             	// Interrupt and Reset on MR0
    T0TCR = 1;                             	// Timer0 Enable
	VICVectAddr0 = (unsigned long)IRQ_Exception;  	// set interrupt vector in 0
    VICVectCntl0 = 0x20 | 4;                    // use it for Timer 0 Interrupt
    VICIntEnable = 0x00000010;                  // Enable Timer0 Interrupt
}
