# We will use GPU servers
# configure your system .bashrc or .cshrc files.
# example .bashrc:
export PATH=/usr/local/cuda-11.0/bin:$PATH
export CUDA_INSTALL_DIR=/usr/local/cuda-11.0
export LD_LIBRARY_PATH=/usr/local/cuda-11.0/lib64:$LD_LIBRARY_PATH

# In the installation process, if your home disk quota exceeds, please clean ~/.cache/pip
# It's recommended to use virtual environment.

# install requirements
pip install -r requirements.txt

# step into TensorRT-7.X.X.X/python
# install Python TensorRT wheel file (consistent with python version, e.g., cp36)
cd ./TensorRT-7.2.1.6/python
pip install tensorrt-7.2.1.6-cp36-none-linux_x86_64.whl

# install graphsurgeon
cd ./TensorRT-7.2.1.6/graphsurgeon
pip install graphsurgeon-0.4.5-py2.py3-none-any.whl

# install onnx_graphsurgeon
cd ./TensorRT-7.2.1.6/onnx_graphsurgeon
pip install onnx_graphsurgeon-0.2.6-py2.py3-none-any.whl

# check your installations in lib, include, data, etc.
# configure your system .bashrc or .cshrc files.
# example:
export LD_LIBRARY_PATH=xxx/TensorRT-7.2.1.6/lib:$LD_LIBRARY_PATH

##########################################################
# Some tests:
# Here you may need to install some python packages.
# Please install them by yourself.

# download the MNIST dataset
cd ./TensorRT-7.2.1.6/data/mnist
python download_pgms.py

# build and run the sample code
cd ./TensorRT-7.2.1.6/samples/sampleMNIST
make
# the compiled binary executable file is TensorRT-7.X.X.X/bin/sample_mnist
# step into TensorRT-7.X.X.X/bin and run the ./sample_mnist
cd ./TensorRT-7.2.1.6/bin
./sample_mnist

