#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#define BUF_SIZE 1024

void trans(FILE* fin, FILE* fout)
{
	int i, j;
	char buf[BUF_SIZE];
	char label[10];
	int delay0, power0, delay1, power1;
	int ptemp, dtemp;
	int pstep, dstep;
	int diff;
	
	i = 0;
	while(fgets(buf, BUF_SIZE, fin) != NULL)
	{
		sscanf(buf, "%s %ld %ld %ld %ld\n", label, &delay0, &power0, &delay1, &power1);
		dstep = (delay1 - delay0)/3;
		pstep = (power0 - power1)/3;
		diff = pstep/5;
		fprintf(fout, "sb%ld %ld %ld ", i, delay0, power0);
		dtemp = delay0 + dstep;
		ptemp = power0 - pstep - diff;
		fprintf(fout, "%ld %ld ", dtemp, ptemp);
		dtemp += dstep;
		ptemp -= pstep;
		fprintf(fout, "%ld %ld %ld %ld\n", dtemp, ptemp, delay1, power1);	
		i ++;
	}
}

int main(int argc, char** argv)
{
	FILE* fin;
	FILE* fout;

	if(argc < 2)
	{
		printf("Input file must be specified!\n");
		return 1;
	}
	
	fin = (FILE*)fopen(argv[1], "r");
	fout = (FILE*)fopen("new.dp", "w");

	trans(fin, fout);

	fclose(fin);
	fclose(fout);

	return 0;
}
