#########################################################
#                                                       #
#      R code for generating synthetic data             # 
#                                                       #
#                  Han Li                               #
#          Last update: Sep 18, 2014                    #
#                                                       #
#########################################################
                                                              

N=300     #number of genes
J=20      #number of experiment conditions
K=6       #number of clusters
R=4       #number of replicates
clusterLabel=rep(seq(1,6),each=50)  #true clustering



#cluster specific mean vector

mu=matrix(0,K,J)
for(k in 1:4){
   for(j in 1:J){
       mu[k,j]=sin(2*pi*j/10-pi*k/4)
      }
   }

mu[5,]=seq(1,J)/20
mu[6,]=-mu[5,]


#five cases in simulation study
                               
                                                         
sigma=matrix(0,5,3)
sigma[1,]=c(0.2,0.1,0.5)
sigma[2,]=rep(0.3,3)
sigma[3,]=c(0.2,0,0.5)
sigma[4,]=c(0,0.2,0.5)
sigma[5,]=c(0,0,0.55)
            

for(case0 in 1:5){
    for(rept in 1:1){

        y=matrix(0,N,J*R)
        for(i in 1:200){
            noise1=rnorm(1,0,sd=sigma[case0,1])
            for(j in 1:J){
                noise2=rnorm(1,0,sd=sigma[case0,2])
                for(r in 1:R){
                    y[i,((j-1)*R+r)]=mu[clusterLabel[i],j]+noise1+noise2+rnorm(1,0,sd=sigma[case0,3])
                    }
              }
          }


        for(i in 201:300){
            noise1=rnorm(1,0,sd=0.5*sigma[case0,1])
            for(j in 1:J){
                noise2=rnorm(1,0,sd=0.5*sigma[case0,2])
                for(r in 1:R){
                   y[i,((j-1)*R+r)]=mu[clusterLabel[i],j]+noise1+noise2+rnorm(1,0,sd=sigma[case0,3])
                    }
                }
            }
            
        write.table(round(y,4),paste("case",case0,"_rept",rept,".txt",sep=""),sep="\t",row.names=FALSE,col.names=FALSE)
        
              
        }
     }
     
     
        




