source('myHHG.R')
require(splines)
require(mvtnorm)
require(energy)
require(acepack)
source('./NIS-code/NIS.R')

SISs <- function(X,Y,method=c('SIS','NIS','DC','RRCS','MC','HHG'))
{
  method=match.arg(method)
  #cat('Current method',method,'\n')
  taus <-NULL
  p=dim(X)[2]
  if(method=='HHG'){
    taus=unlist(lapply(1:p,lmyHHG,X,Y))
    morder=order(taus,decreasing = T)
    values=taus
  }else if(method=='NIS'){
    data=list(x=X,y=Y)
    aINIS.fit = adaptINIS(data,DOISIS=F)
    morder=aINIS.fit$initRANKorder
    values=aINIS.fit$value
  }else{
    for(j in 1:p)
    {
      taus[j]=switch(method,DC=dcor(X[,j],Y)
                     ,SIS=cor(X[,j],Y)
                     ,MC=ace(X[,j],Y)$rsq
                     ,RRCS=cor(X[,j],Y,method = 'kendall'))
    }
    taus=abs(taus)
    morder=order(taus,decreasing = T)
    values=taus
  }
 return(list(order=morder,values=values))
}
minisize <- function(morder,tmodel=NULL)
{
  k=length(tmodel)
  ps <- NULL
  for(i in 1:k)
  {
    ps[i]=which(morder==tmodel[i])
  }
  return(max(ps))
}