% Read the image
pf = imread("platform.png");
% Convert the image to grayscale and normalize it to the range [0, 1]
gray_pf = mean(pf, 3) / 255;
[h, w] = size(gray_pf);
figure;subplot(1, 2, 1);imshow(gray_pf);title("Original Image");

U = zeros(h, w);
for n = 0:w-1
    for l = 0:h-1
        U(l+1, n+1) = exp(-2*pi*1i*(l*n/w));
    end
end

% Since h == w
U = U / h;
freq = U * gray_pf * U;
freq(2:10, :) = 0; % Here we randomly mask some frequency components. Later in this course, we will apply some filters to this variable.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Complete the following lines to reconstruct the grayscale image using the above frequency variable. You are not allowed to use the built-in MATLAB function "ifft2"
recon = %?????;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(1, 2, 2);imshow(real(recon));title("Reconstructed Image");

