function Y = edgedetect(inputfile)

[m,n] = size(inputfile);

nw = 32*32;

nbcol = size(colormap(gray),1);

for i=1:n
    
    X = double(reshape(inputfile(:,i), 64, 64));
    [xM, xH, xV, xD] = haar2d(X);
    xH1 = wcodemat(xH,nbcol);
    xV1 = wcodemat(xV,nbcol);
    edge = xH1 + xV1;
    Y(:,i) = reshape(edge,nw,1);
    
end

