#include "basic/pregel-dev.h"
using namespace std;

//input line format: vertexID \t preorder postorder in_num in1 in2 ... out_num out1 out2 ...
//output line format: vertexID \t level preorder postorder in_num in1 in2 ... out_num out1 out2 ...

struct LevelValue_pregel
{
	int level;
	int preorder;
	int postorder;
	vector<VertexID> in_edges;
	vector<VertexID> out_edges;
};

ibinstream & operator<<(ibinstream & m, const LevelValue_pregel & v)
{
	m<<v.level;
	m<<v.preorder;
	m<<v.postorder;
	m<<v.in_edges;
	m<<v.out_edges;
	return m;
}

obinstream & operator>>(obinstream & m, LevelValue_pregel & v)
{
	m>>v.level;
	m>>v.preorder;
	m>>v.postorder;
	m>>v.in_edges;
	m>>v.out_edges;
	return m;
}

//====================================

class LevelVertex_pregel:public Vertex<VertexID, LevelValue_pregel, int>
{
	public:
		void broadcast(int msg)
		{
			vector<VertexID> & nbs=value().out_edges; //only broadcast info to out neighbors
			for(int i=0; i<nbs.size(); i++)
			{
				send_message(nbs[i], msg);
			}
		}

		virtual void compute(MessageContainer & messages)
		{
			if(step_num()==1)
			{
				broadcast(value().level);
			}
			else
			{
				int max_level = messages[0];
				for(int i=1; i<messages.size(); i++)
				{
					if(max_level < messages[i])  max_level = messages[i];
				}
				max_level++;
				if(max_level > value().level)
				{
					value().level = max_level;
					broadcast(value().level);
				}
			}
			vote_to_halt();
		}
};

class LevelWorker_pregel:public Worker<LevelVertex_pregel>
{
	char buf[100];

	public:
		//C version
		virtual LevelVertex_pregel* toVertex(char* line)
		{
			char * pch;
			pch=strtok(line, "\t");
			LevelVertex_pregel* v=new LevelVertex_pregel;
			v->id=atoi(pch);
			pch=strtok(NULL, " ");
            v->value().preorder = atoi(pch);
            pch = strtok(NULL," ");
            v->value().postorder = atoi(pch);
            
            pch = strtok(NULL," ");
			int in_num=atoi(pch);
			for(int i=0; i<in_num; i++)
			{
				pch=strtok(NULL, " ");
				v->value().in_edges.push_back(atoi(pch));
			}
            pch = strtok(NULL," ");
            int out_num = atoi(pch);
            for (int i = 0; i < out_num; i++) {
                pch = strtok(NULL," ");
                v->value().out_edges.push_back(atoi(pch));
            }
            //------------
            if (v->value().in_edges.size() == 0) {
            	v->value().level = 0;
			}
			else {
				v->value().level = -1;
				v->vote_to_halt();
			}
			return v;
		}

		virtual void toline(LevelVertex_pregel* v, BufferedWriter & writer)
		{
			sprintf(buf, "%d\t%d %d %d", v->id, v->value().level, v->value().preorder, v->value().postorder);
			writer.write(buf);
            int in_num = v->value().in_edges.size();
            sprintf(buf, " %d",in_num);
            writer.write(buf);
            for (int i = 0; i < in_num; i++) {
                sprintf(buf, " %d",v->value().in_edges[i]);
                writer.write(buf);
            }
            int out_num = v->value().out_edges.size();
            sprintf(buf, " %d",out_num);
            writer.write(buf);
            for (int i = 0; i < out_num; i++) {
                sprintf(buf, " %d",v->value().out_edges[i]);
                writer.write(buf);
            }
            writer.write("\n");
		}
};

class LevelCombiner_pregel:public Combiner<int>
{
	public:
		virtual void combine(int & old, const int & new_msg)
		{
			if(old < new_msg) old = new_msg;
		}
};

void pregel_level(string in_path, string out_path, bool use_combiner)
{
	WorkerParams param;
	param.input_path=in_path;
	param.output_path=out_path;
	param.force_write=true;
	param.native_dispatcher=false;
	LevelWorker_pregel worker;
	LevelCombiner_pregel combiner;
	if(use_combiner) worker.setCombiner(&combiner);
	worker.run(param);
}
