#include "ioU.h"
#include <vector>
using namespace std;

long long n;

int queryCnt;

char * txtName, * degName, * outName;

edgeL * deg;
edgeS * labelout;
edgeS * labelx, * labely;

bool fc = 0;

//inline 
int query(int x, int y)
{
	if (x == y) return 0;
	int xx = x, yy = y;

	x = ((deg[xx].x<<32)>>32);
	y = ((deg[yy].x<<32)>>32);
	
	if (x > y)
	{
		labelx = labelout + deg[xx].w;
		labely = labelout + deg[yy].y;
	}
	else
	{
		int xy = x; x = y; y = xy;
		labelx = labelout + deg[yy].y;
		labely = labelout + deg[xx].w;
	}
	
	int ans = 10000, i = 0, j = 0;
	
	
	if (labelx[i].x != -1 && labely[j].x != -1)
	while (labelx[i].x < y)
	{

		if (labelx[i].x == labely[j].x) 
		{
			ans = ans>(labelx[i].w + labely[j].w)?(labelx[i].w + labely[j].w):ans;
			if (labelx[++i].x == -1) break;
			if (labely[++j].x == -1) break;
		}
		else if (labelx[i].x < labely[j].x)
		{
			if (labelx[++i].x == -1) break;
		}
		else if (labely[++j].x == -1) break;
	}
	
	while (labelx[i].x != -1 && labelx[i].x < y) i++;
	if (labelx[i].x == y) ans = ans>labelx[i].w?labelx[i].w:ans;
	
		
	return ans;
}


void loadIndex()
{
	inBufL degBuf(degName);
	inBufS outLabel(outName);
	
	n = checkB(degName)/sizeof(edgeL);

	deg = (edgeL *)malloc(sizeof(edgeL)*n);
	labelout = (edgeS*)malloc(checkB(outName));

	printf("%lld vertices\n", n);

	degBuf.start();
	for (int i = 0; i < n; i++)
		degBuf.nextEdge(deg[i]);
	
	outLabel.start();
	for (int i = 0; !outLabel.isEnd; i++)
		outLabel.nextEdge(labelout[i]);

}

int main(int argc, char ** argv)
{
	txtName = argv[1];
	degName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(degName, "%s.deg", txtName);
	
	outName = (char*)malloc(1+strlen(txtName) + 50);
	sprintf(outName, "%s.out", txtName);

	timer tm;
	
	loadIndex();
	
	printf("load time %lf (ms)\n", tm.getTime()*1000);
	

	double sumTime = 0;
	
		
	queryCnt = 1000;
	if (argc > 2) queryCnt = atoi(argv[2]);


	srand(time(NULL));
	int cnt = 0;
	
	
	int qx[queryCnt], qy[queryCnt];
	for (int i = 0; i < queryCnt; i++)
	{
		qx[i] = rand()%n;
		qy[i] = rand()%n;
	}
	
	tm.restart();
	for (int i = 0; i < queryCnt; i++)
	{
		query(qx[i], qy[i]);		
	}
	sumTime += tm.getTime();
	
	
	printf("average time %lf (mirco second)\n", sumTime*1000000/queryCnt);
	
	free(degName);
	free(outName);
	
	free(deg);
	free(labelout);
	
	return 0;
}














