#include "DFS.h"
#include <iostream>
#include <stdio.h>

int main(int argc, char* argv[]) {
	//arg 1: input graph data path
	//arg 2: output graph data path
	//arg 3: V
	//arg 4: E
	//arg 5: start vid

	if(argc < 6)
	{
		cout<<"arg 1: input graph data path"<<endl;
		cout<<"arg 2: output graph data path"<<endl;
		cout<<"arg 3: V"<<endl;
		cout<<"arg 4: E"<<endl;
		cout<<"arg 5: start vid"<<endl;
		return -1;
	}

	DFSGraph graph(atoi(argv[3]), atoi(argv[4]), atoi(argv[5]));

	graph.load(argv[1]);
	cout<<">> (1/6) graph loaded"<<endl;

	graph.compute_scc();
	cout<<">> (2/6) scc computed, # SCCs: "<<graph.getSCC_V()<<endl;

	graph.condensedGraph("condensed.txt");
	cout<<">> (3/6) scc graph written"<<endl;

	DFSGraph cgraph(graph.getSCC_V(), graph.getSCC_E(), 0);
	cgraph.load("condensed.txt");
	if(remove("condensed.txt")!=0){
		cerr<<"Fail to remove intermediate file"<<endl;
		exit(-1);
	}
	cout<<">> (4/6) scc graph reloaded"<<endl;

	cgraph.DFS();
	cout<<">> (5/6) dfs done"<<endl;
	cgraph.outputDG(argv[2], true);
	cout<<">> (6/6) final graph output"<<endl;

	return 0;
}

