# A toy model derived from Simplenet

import torch.nn as nn
import torch.nn.functional as F

__all__ = ['ceng5030_cifar']


class CENG5030(nn.Module):
    def __init__(self):
        super(CENG5030, self).__init__()
        self.conv1 = nn.Conv2d(3, 6, 5)
        self.relu_conv1 = nn.ReLU()
        self.pool1 = nn.MaxPool2d(2, 2)
        self.conv2 = nn.Conv2d(6, 16, 5)
        self.relu_conv2 = nn.ReLU()
        self.pool2 = nn.MaxPool2d(2, 2)
        self.fc1 = nn.Linear(16 * 5 * 5, 120)
        self.relu_fc1 = nn.ReLU()
        self.fc2 = nn.Linear(120, 10)

    def forward(self, x):
        x = self.pool1(self.relu_conv1(self.conv1(x)))
        x = self.pool2(self.relu_conv2(self.conv2(x)))
        x = x.view(-1, 16 * 5 * 5)
        x = self.relu_fc1(self.fc1(x))
        x = self.fc2(x)
        return x


def ceng5030_cifar():
    model = CENG5030()
    return model
