#ifndef GL4D_H
#define GL4D_H

#include <GL/glew.h>

#ifdef WIN32
#define GL4DAPI __declspec(dllexport)
#else
#define GL4DAPI
#endif

#define GL4D_NO_ERROR GL_NO_ERROR
#define GL4D_INIT_ERROR 1
#define GL4Denum GLenum
#define GL4Duint GLuint
#define GL4Dfloat GLfloat
#define GL4Ddouble GLdouble

#define GL4D_TETRAHEDRA 1
#define GL4D_TETRAHEDRA_STRIP 2

#define GL4D_PARAM_SLICE 1

#define GL4D_LIGHT0 1
#define GL4D_POSITION 1

GL4DAPI GLenum gl4DInit(void);

GL4DAPI void gl4DParamui(GL4Denum pname, GLuint param);

GL4DAPI void gl4DLightfv(GL4Denum light, GL4Denum pname, const GL4Dfloat *params);

GL4DAPI void gl4DLoadModelViewMatrixf(GL4Dfloat *m);
GL4DAPI void gl4DLoadVolumeModelViewMatrixf(GL4Dfloat *m);

GL4DAPI void gl4DRenderBegin(void);
GL4DAPI void gl4DRenderEnd(void);

GL4DAPI void gl4DMaterialfv(GL4Dfloat *ambient, GL4Dfloat *diffuse, GL4Dfloat *specular);

GL4DAPI void gl4DSurfacedv(
    GL4Duint *surface, 
    GL4Ddouble *n, GL4Ddouble *v, 
    GL4Duint (*linearizer)(GL4Duint x, GL4Duint y, GL4Duint z), 
    GL4Duint w, GL4Duint h, GL4Duint d
);

GL4DAPI void gl4DActiveSurface(GL4Duint surface);
GL4DAPI void gl4DRenderSurface(GL4Duint surface);

GL4DAPI void gl4DBegin(GL4Denum mode);

GL4DAPI void gl4DVertex4d(GL4Ddouble x, GL4Ddouble y, GL4Ddouble z, GL4Ddouble w);
GL4DAPI void gl4DVertex4dv(const GL4Ddouble *v);

GL4DAPI void gl4DNormal4d(GL4Ddouble x, GL4Ddouble y, GL4Ddouble z, GL4Ddouble w);
GL4DAPI void gl4DNormal4dv(const GL4Ddouble *v);

GL4DAPI void gl4DEnd(void);

#endif /* GL4D_H */

