#include "Arduino.h"
#include <SPI.h>
#include "TLC5615.h"

#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

#define BUFFER_SIZE 120
#define FLASH_SIZE 8 //*1Mbit
#define FLASH_HOLD 8
#define FLASH_CS 9
#define DAC_CS  10

TLC5615 dac(10); // the instantiation of driver for TI TLC5615 DAC chip (refer to TLC5615.h)
uint8_t command[4] = {0x00, 0x00, 0x00, 0x00};
bool flash_ava = true, new_data = false, dump = false;
unsigned long timer;
uint16_t address_counter = 0, page_count = 0, page_size = 4096;
uint16_t s_buffer[BUFFER_SIZE],head = 0, pos = 0; // construct a buffer
uint16_t analogData;
char option;

void Timer2INIT()
{
	noInterrupts();
	TCCR2A = 0;
	TCCR2B = 0;
	TCNT1 = 0;

	OCR2A = 100;
	TCCR2A |= (1 << WGM21);
	TCCR2B |= (1 << CS21);
	TIMSK2 |= (1 << OCIE2A);
	interrupts();
}

ISR(TIMER2_COMPA_vect)
{
	analogData = analogRead(0);
	new_data = true; //A flag whether the new analog data is available to read.
}

void setup() {
    pinMode(DAC_CS, OUTPUT);
    pinMode(FLASH_HOLD, OUTPUT);
    pinMode(FLASH_CS, OUTPUT);
    digitalWrite(DAC_CS, HIGH);
    digitalWrite(FLASH_CS, HIGH);
    digitalWrite(FLASH_HOLD, HIGH);
    Serial.begin(115200);
    SPI.setClockDivider(SPI_CLOCK_DIV8);
    SPI.begin();
    dac.begin();
    sbi(ADCSRA,ADPS2);
   	cbi(ADCSRA,ADPS1);
   	sbi(ADCSRA,ADPS0);
    Timer2INIT();
}

void loop() {
  Serial.println("CENG4480 Sound Recorder");
    Serial.println("1. Record");
    Serial.println("2. Play Back");
    Serial.println("3. Clear All Record");
    Serial.println("select your option: ");
    while(!Serial.available());
    option = Serial.read();
    switch(option)
    {
      case '1':
          FlashStartWrite(page_count);
          Serial.println("start");
            while(1)
            {
                if(new_data && flash_ava) // if the new analog data is available to read, and the next page of flash is ready
                {

                    if(address_counter < 253) // write data into flash until the last two bytes of the current page
                    {   
                        /* Input your code here. */
                        
                        
                    }
                    else
                    {   
                       /* Input your code here. */
                       
                       
                    }
                    new_data = false; // reset flag, "new_data", to wait for the next sampling analog data.                    
                }
                if(new_data && !flash_ava)
                {
                   /* Input your code here. Hint: use buffer to store data*/
                   
                   
                    if(!dump) // dump is a flag indicates start to transffering data from buffer to flash
                    {
                        if(CheckForFinish()) // check whether the flash is available
                        {
                            dump = true;
                            FlashStartWrite(page_count);                   
                        }
                    }
                }

                if(dump) // if start to transffering data from buffer to flash
                {                       
                    uint16_t get_data;
                    if(popBuffer(&get_data)) {
                       /* Input your code here. */

                       
                    }
                    else
                    {
                        dump = false;
                        flash_ava = true;
                        digitalWrite(4, LOW);
                    }
                }

            }
        case '2':
            Serial.println("playing");
            FlashStartRead(0);
            uint16_t temp;
            for(long i = 0; i < 4096;i++)
            {
                for(long j = 0; j < 128; j++)
                {   
                  /* Here new_data changes its states at the speed of sampling
                    so that the audio is played back at the same frenquency. */
                    while(new_data == false){}
                    new_data = false;
                    /* Input your code here. Hint: Start to read data from flash */
                    
                                         
                    digitalWrite(FLASH_HOLD, LOW); // operations on flash to be paused (hold).
                    /* Input your code here. Hint: Start to write data into DAC chip*/
                    
                                       
                    digitalWrite(FLASH_HOLD, HIGH); // operations on flash can resume.
                }
            }
            FlashEndAction();
            Serial.println("finish");
            break;
       case '3':
            DeleteAll();
            Serial.println("finish");   
            break;
    }
}

//-------------------API area------------------//

void FlashStartWrite(uint32_t page)
{
	uint32_t address;
	uint8_t result;
	EnableWrite();
	WaitForEnable();
	digitalWrite(FLASH_CS, LOW);
	address = page * 256;
	command[0] = 0x02;
	command[1] = (address >> 16);
	command[2] = (address >> 8);
	command[3] = address_counter;
  SPI.transfer(command,4);
	delayMicroseconds(10);
}

void FlashStoreByte(uint8_t input)
{
  SPI.transfer(input);
}

void FlashStartRead(uint32_t page)
{
	uint32_t address;
	uint8_t result;
	address = page * 256;
	digitalWrite(FLASH_CS, LOW);
	command[0] = 0x03;
	command[1] = (address >> 16) & 0xFF;
	command[2] = (address >> 8) & 0xFF;
	command[3] = address & 0xFF;
	SPI.transfer(command,4);
	delayMicroseconds(10);
}

uint8_t FlashReadByte()
{
  uint8_t result;
  result = SPI.transfer(0x00);
  //Serial.println(result);
 
  return result;
}

void FlashEndAction()
{
	digitalWrite(FLASH_CS, HIGH);
}

void DeleteAll()
{
  EnableWrite();
  digitalWrite(FLASH_CS, LOW);
  SPI.transfer(0x60);
  digitalWrite(FLASH_CS, HIGH);
  WaitForFinish();
}

void WaitForFinish()
{
  uint8_t result;
  digitalWrite(FLASH_CS, LOW);
  result = SPI.transfer(0x05);
  SPI.transfer(0x00);
  while(result & 0x01 == 1)
  {
    result = SPI.transfer(0x05);
  }
  digitalWrite(FLASH_CS, HIGH);
}

boolean CheckForFinish()
{
  uint8_t result;
  digitalWrite(FLASH_CS, LOW);
  SPI.transfer(0x05);
  result = SPI.transfer(0x00);
  digitalWrite(FLASH_CS, HIGH);
  if(result & 0x01 == 1)
    return false;
  else
    return true;
  
}

void EnableWrite()
{
  digitalWrite(FLASH_CS, LOW);
  SPI.transfer(0x06);
  digitalWrite(FLASH_CS, HIGH);
}

void addBuffer(uint16_t temp)
{
  s_buffer[pos] = temp;
  pos++;
  if(pos == BUFFER_SIZE)
    pos = 0;
}

bool popBuffer(uint16_t* output)
{
  if(head == pos)
  {
    //SPI.transfer16(head);
    head = pos = 0;
    
    return false;
  }
  *output = s_buffer[head];
  head++;
  if(head == BUFFER_SIZE)
    head = 0;
  return true;
}

void FlashStoreWord(uint16_t input)
{
  SPI.transfer16(input);
}

uint16_t FlashReadWord()
{
  uint8_t result;
  uint16_t flash_read = 0;
  result = SPI.transfer(0x00);
  //Serial.println(result);
  flash_read |= result << 8;
  result = SPI.transfer(0x00);
  //Serial.println(result);
  flash_read |= result;
  return flash_read;
}

void ClearFlash()
{
	EnableWrite();
	WaitForEnable();
	command[0] = 0x20;
	digitalWrite(FLASH_CS, LOW);
	SPI.transfer(command,4);
	digitalWrite(FLASH_CS, HIGH);
	WaitForFinish();
}

void WaitForEnable()
{
	uint8_t result;
	digitalWrite(FLASH_CS, LOW);
	SPI.transfer(0x05);
	result = SPI.transfer(0x00);
	while(result & 0x10 == 1)
	{
		SPI.transfer(0x05);
		result = SPI.transfer(0x00);
	}
	digitalWrite(FLASH_CS, HIGH);
}
