
% function h = gaussian_kernel (m,n, sigma)
% h = ones(m,n);
% center_x = (m+1)/2; center_y = (n+1)/2;
% for i = 1:m
%     for j = 1:n
%         h(i,j) = exp(-((i-center_x)^2+(j-center_y)^2)/(2*sigma^2));
%     end
% end
% h = h./sum(h(:));
% 
% return;


function h = gaussian_kernel (m,n, sigma)
h = ones(m,n);
center_x = (m+1)/2; center_y = (n+1)/2;
for i = 1:m
    for j = 1:n
        r = sqrt((i-center_x)^2+(j-center_y)^2);
        h(i,j) = exp(-(r^2)/(2*sigma^2));
    end
end
h = h./sum(h(:));

return;


