
function centered_h = centering_kernel (h, M,N)

[m,n] = size(h); centered_h = zeros(M,N);

if (mod(m,2) == 1) && (mod(n,2) == 1)
% if size_h is odd ---> whole-point symmetry, often referring to convolution kernel 
% top-left
centered_h(1:(m+1)/2,1:(n+1)/2) = h((m+1)/2:m,(n+1)/2:n);
% bottom-right
centered_h(M-(m-1)/2+1:M,N-(n-1)/2+1:N) = h(1:(m-1)/2,1:(n-1)/2);
% top-right
centered_h(1:(m+1)/2,N-(n-1)/2+1:N) = h((m+1)/2:m,1:(n-1)/2);
% bottom-left
centered_h(M-(m-1)/2+1:M,1:(n+1)/2) = h(1:(m-1)/2,(n+1)/2:n);
end

return;