function varargout = BLUR_SURE_GUI(varargin)
% BLUR_SURE_GUI M-file for BLUR_SURE_GUI.fig
%      BLUR_SURE_GUI, by itself, creates a new BLUR_SURE_GUI or raises the existing
%      singleton*.
%
%      H = BLUR_SURE_GUI returns the handle to a new BLUR_SURE_GUI or the handle to
%      the existing singleton*.
%
%      BLUR_SURE_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BLUR_SURE_GUI.M with the given input
%      arguments.
%
%      BLUR_SURE_GUI('Property','Value',...) creates a new BLUR_SURE_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before BLUR_SURE_GUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property
%      application
%      stop.  All inputs are passed to BLUR_SURE_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help BLUR_SURE_GUI

% Last Modified by GUIDE v2.5 26-Jul-2015 12:06:37

newcd=fileparts(mfilename('fullpath'));
addpath(genpath(newcd))

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @BLUR_SURE_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @BLUR_SURE_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before BLUR_SURE_GUI is made visible.
function BLUR_SURE_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to BLUR_SURE_GUI (see VARARGIN)


    set(handles.show_blurred,'visible','off');   set(handles.show_curve, 'visible','off');   
    set(handles.show_blind,'visible','off');       set(handles.show_non_blind,'visible','off');       
    
    set(handles.text_bsnr,'visible','off');     set(handles.text_true_scaling_factor,'visible','off');  
    set(handles.text_noise_variance,'visible','off');   set(handles.text_input_psnr,'visible','off'); 
    set(handles.text_est_scaling_factor,'visible','off');   set(handles.text_est_scaling_factor_oracle,'visible','off');
    set(handles.text_running_time,'visible','off'); set(handles.noisest,'visible','off');
    set(handles.text_blind_psnr,'visible','off');      set(handles.text_non_blind_psnr,'visible','off');
    set(handles.text_blind_ssim,'visible','off');      set(handles.text_non_blind_ssim,'visible','off');
     
% p = mfilename('fullpath') ;
% addpath(p(1:end-12));

set(gcf,'units','normalized');

handles.output = hObject;

global extension filter; 
extension = {'periodic', 'half_point'};     filter = {'experiment_1'};

global blur_type; blur_type = 1;
global bsnr; bsnr = 20;

global noise_variance est_noise_variance; noise_variance = 1;

% Update handles structure
guidata(hObject, handles);

if strcmp(get(hObject,'Visible'),'off')
    initialize_gui(hObject, handles);
end

% UIWAIT makes BLUR_SURE_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = BLUR_SURE_GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function initialize_gui(fig_handle, handles)

setappdata(0, 'test_data', '1');


% --- Executes on button press in button_load_image.
function button_load_image_Callback(hObject, eventdata, handles)
% hObject    handle to button_load_image (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global x filter y h noise_variance est_noise_variance;
global y_blurred blur_std blur_type; 
global theta sigma_1 sigma_2;

theta = pi/4;  sigma_1 = 2; sigma_2 = 4;

[x,  img_name]=loadimage_mat();
[M, N] = size(x);
set(handles.text21, 'String', ['Noisy blurred image (' num2str(M) 'x' num2str(N) ')']);

if x==-1
    return
else

blur_type = get (handles.pop_blur_kernel, 'value');
       
switch blur_type
       
    case 1
        blur_std = get(handles.slider_scaling_factor,'value');  set(handles.text_true_scaling_factor,'String', sprintf('%3.2f',blur_std)); 
        filter  = {'gaussian', blur_std};
        
    case 2
        blur_std = get(handles.slider_scaling_factor,'value');  set(handles.text_true_scaling_factor,'String', sprintf('%3.2f',blur_std)); 
        filter  = {'jinc', blur_std};

    case 3
        blur_std = get(handles.slider_scaling_factor,'value');  set(handles.text_true_scaling_factor,'String', sprintf('%3.2f',blur_std)); 
        filter  = {'non_symmetric', blur_std, theta, sigma_1, sigma_2 };

end

if (isempty(handles.pop_blur_kernel ))
     set(hObject,'String','0')
end

bsnr = get(handles.slider_bsnr,'value');  set(handles.text_bsnr, 'String', sprintf('%5.2f %s',bsnr,'dB'));

% extension_case ='periodic';     symmetry_type = 'NA';
% extension_case ='symmetric';     symmetry_type = 'half_point';
% extension_case = extension{1};     symmetry_type = extension{2};

[y_blurred, h] = image_blurring(x, filter ); [M, N] = size(y_blurred);
y_energy = y_blurred-mean(y_blurred(:)); y_energy = y_energy(:)'*y_energy(:)/(M*N);
noise_variance = y_energy*10^(-bsnr/10);
y = image_add_noise(y_blurred, noise_variance);
est_noise_variance = estimation_noise_variance(y);

set(handles.text_noise_variance, 'String', sprintf('%3.2f',noise_variance));

axes(handles.show_blurred); colormap(gray(256)); image(y);  axis image; axis off;
c = PSNR(y,x,255); c = sprintf('%5.2f %s',c,'dB');   
% set(handles.input_psnr, 'String', c);
set(handles.text_input_psnr, 'String', c);

axes(handles.show_non_blind); cla reset; axis off;
axes(handles.show_blind); cla reset; axis off;
axes(handles.show_curve); cla reset; axis off;


    set(handles.text_bsnr,'visible','on');     set(handles.text_true_scaling_factor,'visible','on');  
    set(handles.text_noise_variance,'visible','on');   set(handles.text_input_psnr,'visible','on'); 
    set(handles.text_est_scaling_factor,'visible','off');   set(handles.text_est_scaling_factor_oracle,'visible','off');
    set(handles.text_running_time,'visible','off'); set(handles.noisest,'visible','off');
    set(handles.text_blind_psnr,'visible','off');      set(handles.text_non_blind_psnr,'visible','off');
    set(handles.text_blind_ssim,'visible','off');      set(handles.text_non_blind_ssim,'visible','off');
    
guidata(hObject, handles); 

end
% return;


% --- Executes on selection change in pop_blur_kernel.
function pop_blur_kernel_Callback(hObject, eventdata, handles)
% hObject    handle to pop_blur_kernel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns pop_blur_kernel contents as cell array
%        contents{get(hObject,'Value')} returns selected item from
%        pop_blur_kernel
global filter x y h noise_variance est_noise_variance;
global y_blurred blur_type blur_std; 
global theta sigma_1 sigma_2;

if isempty(y)
    warndlg('Please load an image first!')
    return
end

blur_type = get (handles.pop_blur_kernel, 'value');

switch blur_type
    
    case 1
        blur_std = get(handles.slider_scaling_factor,'value');  set(handles.text_true_scaling_factor,'String', sprintf('%3.2f',blur_std)); 
        filter  = {'gaussian', blur_std};
        
    case 2
        blur_std = get(handles.slider_scaling_factor,'value');  set(handles.text_true_scaling_factor,'String', sprintf('%3.2f',blur_std)); 
        filter  = {'jinc', blur_std};

    case 3
        blur_std = get(handles.slider_scaling_factor,'value');  set(handles.text_true_scaling_factor,'String', sprintf('%3.2f',blur_std)); 
        filter  = {'non_symmetric', blur_std, theta, sigma_1, sigma_2};
        
end
        
if (isempty(handles.pop_blur_kernel ))
     set(hObject,'String','0')
end


bsnr = get(handles.slider_bsnr,'value');  set(handles.text_bsnr,'String', sprintf('%5.2f %s',bsnr,'dB'));

[M, N] = size(y_blurred); mean_y = mean(y_blurred(:));
y_energy = y_blurred-mean_y; y_energy = y_energy(:)'*y_energy(:)/(M*N);
noise_variance = y_energy*10^(-bsnr/10);

% extension_case ='periodic';     symmetry_type = 'NA';
% extension_case ='symmetric';     symmetry_type = 'half_point';
% extension_case = extension{1};     symmetry_type = extension{2};

[y_blurred, h] = image_blurring (x, filter );
y = image_add_noise(y_blurred, noise_variance);
est_noise_variance = estimation_noise_variance(y);

set(handles.text_noise_variance, 'String', sprintf('%3.2f',noise_variance));


axes(handles.show_blurred); colormap(gray(256)); image(y);  axis image; axis off;
c = PSNR(y,x,255); c = sprintf('%5.2f %s',c,'dB');   
% set(handles.input_psnr, 'String', c);
set(handles.text_input_psnr, 'String', c);

axes(handles.show_non_blind); cla reset; axis off;
axes(handles.show_blind); cla reset; axis off;
axes(handles.show_curve); cla reset; axis off;


    set(handles.text_bsnr,'visible','on');     set(handles.text_true_scaling_factor,'visible','on');  
    set(handles.text_noise_variance,'visible','on');   set(handles.text_input_psnr,'visible','on'); 
    set(handles.text_est_scaling_factor,'visible','off');   set(handles.text_est_scaling_factor_oracle,'visible','off');
    set(handles.text_running_time,'visible','off'); set(handles.noisest,'visible','off'); 
    set(handles.text_blind_psnr,'visible','off');      set(handles.text_non_blind_psnr,'visible','off');
    set(handles.text_blind_ssim,'visible','off');      set(handles.text_non_blind_ssim,'visible','off');

guidata(hObject, handles); 

return;


% --- Executes during object creation, after setting all properties.
function pop_blur_kernel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pop_blur_kernel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%% slider of scaling factor
% --- Executes on slider movement.
function slider_scaling_factor_Callback(hObject, eventdata, handles)
% hObject    handle to slider_scaling_factor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

global filter x y h noise_variance est_noise_variance;
global y_blurred blur_std blur_type;
global theta sigma_1 sigma_2;

if isempty(y)
    warndlg('Please load an image first!')
    return
end

blur_std = get(handles.slider_scaling_factor,'value');  set(handles.text_true_scaling_factor,'String', sprintf('%3.2f',blur_std)); 
bsnr = get(handles.slider_bsnr,'value');   set(handles.text_bsnr, 'String', sprintf('%5.2f %s',bsnr,'dB'));

[M, N] = size(y_blurred); mean_y = mean(y_blurred(:));
y_energy = y_blurred-mean_y; y_energy = y_energy(:)'*y_energy(:)/(M*N);
noise_variance = y_energy*10^(-bsnr/10);

% extension_case ='periodic';     symmetry_type = 'NA';
% extension_case ='symmetric';     symmetry_type = 'half_point';
% extension_case = extension{1};     symmetry_type = extension{2};

switch blur_type
    case 1
        filter  = {'gaussian', blur_std};
    case 2
        filter  = {'jinc', blur_std};
    case 3
        filter  = {'non_symmetric', blur_std, theta, sigma_1, sigma_2 };
end

[y_blurred, h] = image_blurring(x, filter );
y = image_add_noise(y_blurred, noise_variance);
est_noise_variance = estimation_noise_variance(y);

set(handles.text_noise_variance, 'String', sprintf('%3.2f',noise_variance));


axes(handles.show_blurred); colormap(gray(256)); image(y);  axis image; axis off;
c = PSNR(y,x,255); c = sprintf('%5.2f %s',c,'dB');   set(handles.text_input_psnr, 'String', c);

axes(handles.show_non_blind); cla reset; axis off;
axes(handles.show_blind); cla reset; axis off;
axes(handles.show_curve); cla reset; axis off;

    set(handles.text_bsnr,'visible','on');     set(handles.text_true_scaling_factor,'visible','on');  
    set(handles.text_noise_variance,'visible','on');   set(handles.text_input_psnr,'visible','on'); 
    set(handles.text_est_scaling_factor,'visible','off');   set(handles.text_est_scaling_factor_oracle,'visible','off');
    set(handles.text_running_time,'visible','off');  set(handles.noisest,'visible','off'); 
    set(handles.text_blind_psnr,'visible','off');      set(handles.text_non_blind_psnr,'visible','off');
    set(handles.text_blind_ssim,'visible','off');      set(handles.text_non_blind_ssim,'visible','off');
     
guidata(hObject, handles); 

return;


% --- Executes during object creation, after setting all properties.
function slider_scaling_factor_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider_scaling_factor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


%% slider of BSNR
% --- Executes on slider movement.
function slider_bsnr_Callback(hObject, eventdata, handles)
% hObject    handle to slider_bsnr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

global filter x y h noise_variance est_noise_variance;
global y_blurred blur_std blur_type; 

if isempty(y)
    warndlg('Please load an image first!')
    return
end

bsnr = get(handles.slider_bsnr,'value');   set(handles.text_bsnr,'String', sprintf('%5.2f %s',bsnr,'dB'));

[M, N] = size(y_blurred); mean_y = mean(y_blurred(:));
y_energy = y_blurred-mean_y; y_energy = y_energy(:)'*y_energy(:)/(M*N);
noise_variance = y_energy*10^(-bsnr/10);

% extension_case ='periodic';     symmetry_type = 'NA';
% extension_case ='symmetric';     symmetry_type = 'half_point';
% extension_case = extension{1};     symmetry_type = extension{2};

[y_blurred, h] = image_blurring(x, filter );  y = image_add_noise(y_blurred, noise_variance);
est_noise_variance = estimation_noise_variance(y);

set(handles.text_noise_variance, 'String', sprintf('%3.2f',noise_variance));


axes(handles.show_blurred); colormap(gray(256)); image(y);  axis image; axis off;
c = PSNR(y,x,255); c = sprintf('%5.2f %s',c,'dB');   
% set(handles.input_psnr, 'String', c);
set(handles.text_input_psnr, 'String', c);

axes(handles.show_non_blind); cla reset; axis off;
axes(handles.show_blind); cla reset; axis off;
axes(handles.show_curve); cla reset; axis off;


    set(handles.text_bsnr,'visible','on');     set(handles.text_true_scaling_factor,'visible','on');  
    set(handles.text_noise_variance,'visible','on');   set(handles.text_input_psnr,'visible','on'); 
    set(handles.text_est_scaling_factor,'visible','off');   set(handles.text_est_scaling_factor_oracle,'visible','off');
    set(handles.text_running_time,'visible','off'); set(handles.noisest,'visible','off'); 
    set(handles.text_blind_psnr,'visible','off');      set(handles.text_non_blind_psnr,'visible','off');
    set(handles.text_blind_ssim,'visible','off');      set(handles.text_non_blind_ssim,'visible','off');

guidata(hObject, handles); 

return;


% --- Executes during object creation, after setting all properties.
function slider_bsnr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider_bsnr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

%% blur-SURE minimization to estimate scaling factor
% --- Executes on button press in button_estimation.
function button_estimation_Callback(hObject, eventdata, handles)
% hObject    handle to button_estimation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global filter x y h noise_variance est_noise_variance; 
global y_blurred blur_std blur_type; 
global s_est theta sigma_1 sigma_2; 

if isempty(y)
    warndlg('Please load an image first!')
    return
end
tic; result1 = blur_sure (y, blur_std, est_noise_variance, blur_type, theta, sigma_1, sigma_2 ) ;
running_time = toc; 
if running_time<2
    running_time = sprintf('%3.2f %s',running_time,'second');
else
    running_time = sprintf('%3.2f %s',running_time,'seconds');
end
s_n = result1 (:,1);     lambda_n = result1 (:,2); sure = result1 (:,3);
s_est = s_n(find(sure==min(sure)));  s_est_s = num2str(s_est);


set(handles.noisest, 'String', sprintf('%3.2f',est_noise_variance),'visible','on');
set(handles.text_est_scaling_factor, 'String', s_est_s,'visible','on');
set(handles.text_running_time, 'String', running_time,'visible','on');
drawnow;


result2 = blur_mse (x, y_blurred, y, blur_std, noise_variance, blur_type, theta, sigma_1, sigma_2 ) ;
mse = result2 (:,3);     
s_est_oracle = s_n(find(mse==min(mse)));  s_est_oracle_s = num2str(s_est_oracle);
set(handles.text_est_scaling_factor_oracle, 'String', s_est_oracle_s);


range = abs(min(mse)-min(sure));
if (min(sure)>=min(mse))
range_x = linspace(min(mse)-0.2*range, min(sure)+0.6*range, 30);
else
range_x = linspace(min(sure)-0.2*range, min(mse)+0.6*range, 30);
end

s_est_x = s_est*ones(1,30);     s_est_x_oracle = s_est_oracle*ones(1,30);

axes(handles.show_curve); 
plot(handles.show_curve, s_n, mse, 'r--', 'LineWidth', 2.5); grid on; hold on;
plot(handles.show_curve, s_n, sure,  'LineWidth', 2, 'Color', [0.0, 0.0, 0.5] ); grid on; hold on;
plot(handles.show_curve, s_est_x, range_x, '--', 'LineWidth', 1.5, 'Color', [0.0, 0.0, 0.5] ); grid on; hold on;
plot(handles.show_curve, s_est_x_oracle, range_x, 'r--', 'LineWidth', 1.5); grid on; hold on;
yl=get(gca,'ylim'); set(gca, 'ylim', [range_x(1), yl(2)]);
legend('blur-MSE','blur-SURE');


    set(handles.text_bsnr,'visible','on');     set(handles.text_true_scaling_factor,'visible','on');  
    set(handles.text_noise_variance,'visible','on');   set(handles.text_input_psnr,'visible','on'); 
    set(handles.text_est_scaling_factor,'visible','on');   set(handles.text_est_scaling_factor_oracle,'visible','on');
    set(handles.text_running_time,'visible','on'); 
%     set(handles.text_blind_psnr,'visible','off');      set(handles.text_non_blind_psnr,'visible','off');
%     set(handles.text_blind_ssim,'visible','off');      set(handles.text_non_blind_ssim,'visible','off');
    
return;


% --- Executes on button press in button_blind.
function button_blind_Callback(hObject, eventdata, handles)
% hObject    handle to button_blind (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% global lambda_1 lambda_2 lambda_3 beta mu; 
global x y noise_variance est_noise_variance; 
global sure_image mse_image;
global blur_type blur_std s_est;
global theta sigma_1 sigma_2; 

if isempty(y)
    warndlg('Please load an image first!')
    return
end
if isempty(s_est)|strcmp(get(handles.text_est_scaling_factor,'visible'),'off')
    warndlg('Please perform PSF estimation first!')
    return
end

extension_case ='periodic';     symmetry_type = 'NA';
% extension_case ='symmetric';     symmetry_type = 'half_point';

if noise_variance == 0
    noise_variance = eps;
end

 [sure_image, mse_image] =   SURE_LET_Deconvolution_Complete  ...
    (x, y, blur_type, s_est, est_noise_variance, extension_case, symmetry_type, theta, sigma_1, sigma_2) ;

axes(handles.show_blind); colormap(gray(256)); image(sure_image);  axis image; axis off;

output_blind = PSNR(sure_image,x,255);    output_blind_s = sprintf('%5.2f %s',output_blind,'dB');   
set(handles.text_blind_psnr, 'String', output_blind_s);

ssim_blind = ssim (sure_image,x);    ssim_blind_s = sprintf('%1.3f',ssim_blind);   
set(handles.text_blind_ssim, 'String', ssim_blind_s);

    set(handles.text_bsnr,'visible','on');     set(handles.text_true_scaling_factor,'visible','on');  
    set(handles.text_noise_variance,'visible','on');   set(handles.text_input_psnr,'visible','on'); 
    set(handles.text_est_scaling_factor,'visible','on');   set(handles.text_est_scaling_factor_oracle,'visible','on');
    set(handles.text_running_time,'visible','on'); set(handles.noisest,'visible','on'); 
    set(handles.text_blind_psnr,'visible','on');      % set(handles.text_non_blind_psnr,'visible','off');
    set(handles.text_blind_ssim,'visible','on');      % set(handles.text_non_blind_ssim,'visible','off');
    
guidata(hObject, handles); 



% --- Executes on button press in button_non_blind.
function button_non_blind_Callback(hObject, eventdata, handles)
% hObject    handle to button_non_blind (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global x y noise_variance est_noise_variance; 
global sure_image mse_image;
global blur_type blur_std s_est;
global theta sigma_1 sigma_2; 

if isempty(y)
    warndlg('Please load an image first!')
    return
end

extension_case ='periodic';     symmetry_type = 'NA';
% extension_case ='symmetric';     symmetry_type = 'half_point';

if noise_variance == 0
    noise_variance = eps;
end

 [sure_image, mse_image] =   SURE_LET_Deconvolution_Complete  ...
    (x, y, blur_type, blur_std, noise_variance, extension_case, symmetry_type, theta, sigma_1, sigma_2 ) ;

axes(handles.show_non_blind); colormap(gray(256)); image(sure_image);  axis image; axis off;

output_non_blind = PSNR(sure_image,x,255);    output_non_blind_s = sprintf('%5.2f %s',output_non_blind,'dB');   
set(handles.text_non_blind_psnr, 'String', output_non_blind_s);

ssim_non_blind = ssim (sure_image,x);    ssim_non_blind_s = sprintf('%1.3f',ssim_non_blind);   
set(handles.text_non_blind_ssim, 'String', ssim_non_blind_s);

    set(handles.text_bsnr,'visible','on');     set(handles.text_true_scaling_factor,'visible','on');  
    set(handles.text_noise_variance,'visible','on');   set(handles.text_input_psnr,'visible','on'); 
%     set(handles.text_est_scaling_factor,'visible','on');   set(handles.text_est_scaling_factor_oracle,'visible','on');
%     set(handles.text_running_time,'visible','on'); 
%     set(handles.text_blind_psnr,'visible','on');      
%     set(handles.text_blind_ssim,'visible','on');      
   set(handles.text_non_blind_psnr,'visible','on');
   set(handles.text_non_blind_ssim,'visible','on');
    
guidata(hObject, handles); 

%% Quit buttion
% --- Executes on button press in button_quit.
function button_quit_Callback(hObject, eventdata, handles)
clc;      clear all; close all; delete(gcf);
return;
