function varargout = ilet_deconv_gui(varargin)
% ILET_DECONV_GUI MATLAB code for ilet_deconv_gui.fig
%      ILET_DECONV_GUI, by itself, creates a new ILET_DECONV_GUI or raises the existing
%      singleton*.
%
%      H = ILET_DECONV_GUI returns the handle to a new ILET_DECONV_GUI or the handle to
%      the existing singleton*.
%
%      ILET_DECONV_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in ILET_DECONV_GUI.M with the given input arguments.
%
%      ILET_DECONV_GUI('Property','Value',...) creates a new ILET_DECONV_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before ilet_deconv_gui_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to ilet_deconv_gui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help ilet_deconv_gui

% Last Modified by GUIDE v2.5 12-Dec-2012 18:18:18

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @ilet_deconv_gui_OpeningFcn, ...
                   'gui_OutputFcn',  @ilet_deconv_gui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before ilet_deconv_gui is made visible.
function ilet_deconv_gui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to ilet_deconv_gui (see VARARGIN)

dir=fileparts(mfilename('fullpath'));
addpath(genpath([dir(1:end-3),'tools']));
addpath([dir(1:end-3),'image']);
addpath([dir(1:end-3),'src']);

% read cameraman image
im = double(imread('cameraman.tif'));
N = size(im,1);
% crop a square image
im = im(1:N,1:N);
ker = 5;
bSize = 9;
[ psf, psf0 ] = convKernel( N, ker, bSize);
BSNR = 40;

y = convolve2(im,psf);
sigma = norm(y-mean(y(:)),'fro')/sqrt(N*N*10^(0.1*BSNR));
randn('state',[362436069;521288629]);
noise = sigma.*randn(N,N);
blurred = convolve2(im,psf) + noise;
deblurred = blurred;

SNRin = SNR( blurred, im );
SSIMin = ssim_index( blurred, im );

% update handles' fields
handles.img = im;
handles.N = N;
handles.ker = ker;
handles.bSize = bSize;
handles.psf = psf;
handles.psf0 = psf0;
handles.bsnr = BSNR;
handles.n_eng = norm(noise,'fro')^2;
handles.blurred = blurred;
handles.deblurred = deblurred;
handles.SNRin = SNRin;
handles.SSIMin = SSIMin;

% show images
set(gcf,'CurrentAxes', handles.org_img);
imshow(uint8(handles.img));
set(handles.org_img_name,'String',...
    ['Original Image (',num2str(N),' x ',num2str(N),')']);
% title(['Original Image (',num2str(N),' x ',num2str(N),')']);
% ---------------------------------------
set(gcf,'CurrentAxes', handles.blur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.blur_img_name,'String',...
    ['Blurred Image (',num2str(N),' x ',num2str(N),')']);
% title(['Blurred Image (',num2str(N),' x ',num2str(N),')']);
% ---------------------------------------
set(gcf,'CurrentAxes', handles.deblur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.deblur_img_name,'String',...
    ['Deblurred Image (',num2str(N),' x ',num2str(N),')']);
% title(['Deblurred Image (',num2str(N),' x ',num2str(N),')']);
text('Position',[floor(handles.N/2),floor(handles.N/2)],...
    'String','{\bf Not Deblurred yet!}','HorizontalAlignment','center',...
    'Rotation',30,'Color','yellow','FontName','Helvetica',...
    'FontSize',16,'Interpreter','latex');
% ---------------------------------------
linkaxes([handles.org_img handles.blur_img handles.deblur_img]);

% update GUI components displays
set(handles.img_name,'Value',1);
set(handles.blur_kernel,'Value',1);
set(handles.bsnr_slider,'Value',40);
set(handles.bsnr_input,'String',num2str(handles.bsnr,'%.0f'));
set(handles.blur_size,'String','9');
set(handles.snr_in,'String',[num2str(handles.SNRin,'%.2f'),' dB']);
set(handles.ssim_in,'String',num2str(handles.SSIMin,'%.2f'));
set(handles.snr_out,'String','---');
set(handles.ssim_out,'String','---');
set(findobj('Tag','time'),'String','---');

pos_bsnr_slider=get(handles.bsnr_slider,'Position');
pos_bsnr_input=get(handles.bsnr_input,'Position');
if ismac
set(handles.bsnr_input,'Position',...
    [pos_bsnr_input(1) pos_bsnr_slider(2)-0.03 pos_bsnr_input(3) pos_bsnr_slider(4)+0.06]);
else
set(handles.bsnr_input,'Position',...
    [pos_bsnr_input(1) pos_bsnr_slider(2)-0.012 pos_bsnr_input(3) pos_bsnr_slider(4)+0.024]);
end
% % embed a Java progress bar
% jPb = javax.swing.JProgressBar;
% jPb.setStringPainted(true);
% jPb.setIndeterminate(0);
% % put it in a proper location in relative to the result panel
% set(handles.results,'Units','pixels');
% set(handles.run,'Units','pixels');
% 
% posRef1 = get(handles.results,'Position');
% posRef2 = get(handles.run,'Position');
% hPbPos = [posRef1(1) posRef1(2)-0.87*posRef2(4) posRef1(3) 0.6*posRef2(4)];
% handles.hPb = javacomponent(jPb,hPbPos,gcf);
% 
% set(handles.results,'Units','characters');
% set(handles.run,'Units','characters');

% Choose default command line output for ilet_deconv_gui
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes ilet_deconv_gui wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = ilet_deconv_gui_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in run.
function run_Callback(hObject, eventdata, handles)
% hObject    handle to run (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% if isinf(handles.bsnr)
% tic,
% deblurred = TikhonovDecon(handles.blurred,handles.psf,eps);
% time=toc;
% else
tic,
deblurred = iLET_deconv(handles.blurred,handles.psf,'N_ENG',handles.n_eng);
time=toc;
% end
SNRout = SNR(deblurred,handles.img);
SSIMout = ssim_index(deblurred,handles.img);

% update handles' fields
handles.deblurred = deblurred;
handles.SNRout = SNRout;
handles.SSIMout = SSIMout;
handles.time = time;

% show images
set(gcf,'CurrentAxes', handles.deblur_img);
imshow(uint8(deblurred));
set(handles.deblur_img_name,'String',...
    ['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
linkaxes([handles.org_img handles.blur_img handles.deblur_img]);

% update GUI components displays
set(handles.snr_out,'String',[num2str(SNRout,'%.2f'),' dB']);
set(handles.ssim_out,'String',num2str(SSIMout,'%.2f'));
set(findobj('Tag','time'),'String',[num2str(time,'%.2f'),' sec']);

guidata(hObject, handles);

% --- Executes on button press in reset.
function reset_Callback(hObject, eventdata, handles)
% hObject    handle to reset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ilet_deconv_gui_OpeningFcn(hObject, eventdata, handles);

% --- Executes on button press in close.
function close_Callback(hObject, eventdata, handles)
% hObject    handle to close (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
delete(handles.figure1);

% --- Executes on slider movement.
function bsnr_slider_Callback(hObject, eventdata, handles)
% hObject    handle to bsnr_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

handles.bsnr = round(get(hObject,'Value'));
set(handles.bsnr_input,'String',num2str(handles.bsnr,'%.0f'));

y = convolve2(handles.img,handles.psf);
sigma = norm(y-mean(y(:)),'fro')/sqrt(handles.N*handles.N*10^(0.1*handles.bsnr));
randn('state',[362436069;521288629]);
noise = sigma.*randn(handles.N,handles.N);
blurred = convolve2(handles.img,handles.psf) + noise;
deblurred = blurred;

SNRin = SNR( blurred, handles.img );
SSIMin = ssim_index( blurred, handles.img );

% update handles' fields
handles.n_eng = norm(noise,'fro')^2;
handles.blurred = blurred;
handles.deblurred = deblurred;
handles.SNRin = SNRin;
handles.SSIMin = SSIMin;

% show images
set(gcf,'CurrentAxes', handles.blur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.blur_img_name,'String',...
    ['Blurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Blurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% ---------------------------------------
set(gcf,'CurrentAxes', handles.deblur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.deblur_img_name,'String',...
    ['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
text('Position',[floor(handles.N/2),floor(handles.N/2)],...
    'String','{\bf Not Deblurred yet!}','HorizontalAlignment','center',...
    'Rotation',30,'Color','yellow','FontName','default',...
    'FontSize',16,'Interpreter','latex');
% ---------------------------------------
linkaxes([handles.org_img handles.blur_img handles.deblur_img]);

% update GUI displays
set(findobj('Tag','snr_in'),'String',[num2str(handles.SNRin,'%.2f'),' dB']);
set(findobj('Tag','ssim_in'),'String',num2str(handles.SSIMin,'%.2f'));
set(findobj('Tag','snr_out'),'String','---');
set(findobj('Tag','ssim_out'),'String','---');
set(findobj('Tag','time'),'String','---');

guidata(hObject,handles);


% --- Executes during object creation, after setting all properties.
function bsnr_slider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bsnr_slider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


function bsnr_input_Callback(hObject, eventdata, handles)
% hObject    handle to bsnr_input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bsnr_input as text
%        str2double(get(hObject,'String')) returns contents of bsnr_input as a double
val = round(str2double(get(hObject,'String')));
minVal = get(handles.bsnr_slider,'Min');
maxVal = get(handles.bsnr_slider,'Max');
valUsed=min(max(val,minVal),maxVal);
set(handles.bsnr_slider,'Value',valUsed);
% % % % % % % % % % % % % % % % % % % % % % % % 
% if val>maxVal
% set(hObject,'String','inf');
% handles.bsnr = inf;
% else
% % % % % % % % % % % % % % % % % % % % % % % % 
% set(hObject,'String',num2str(valUsed,'%.1f'));
handles.bsnr = val;
% end

y = convolve2(handles.img,handles.psf);
sigma = norm(y-mean(y(:)),'fro')/sqrt(handles.N*handles.N*10^(0.1*handles.bsnr));
randn('state',[362436069;521288629]);
noise = sigma.*randn(handles.N,handles.N);
blurred = convolve2(handles.img,handles.psf) + noise;
deblurred = blurred;

SNRin = SNR( blurred, handles.img );
SSIMin = ssim_index( blurred, handles.img );

% update handles' fields
handles.n_eng = norm(noise,'fro')^2;
handles.blurred = blurred;
handles.deblurred = deblurred;
handles.SNRin = SNRin;
handles.SSIMin = SSIMin;

% show images
set(gcf,'CurrentAxes', handles.blur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.blur_img_name,'String',...
    ['Blurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Blurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% ---------------------------------------
set(gcf,'CurrentAxes', handles.deblur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.deblur_img_name,'String',...
    ['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
text('Position',[floor(handles.N/2),floor(handles.N/2)],...
    'String','{\bf Not Deblurred yet!}','HorizontalAlignment','center',...
    'Rotation',30,'Color','yellow','FontName','default',...
    'FontSize',16,'Interpreter','latex');
% ---------------------------------------
linkaxes([handles.org_img handles.blur_img handles.deblur_img]);

% update GUI displays
set(findobj('Tag','snr_in'),'String',[num2str(handles.SNRin,'%.2f'),' dB']);
set(findobj('Tag','ssim_in'),'String',num2str(handles.SSIMin,'%.2f'));
set(findobj('Tag','snr_out'),'String','---');
set(findobj('Tag','ssim_out'),'String','---');
set(findobj('Tag','time'),'String','---');

guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function bsnr_input_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bsnr_input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in img_name.
function img_name_Callback(hObject, eventdata, handles)
% hObject    handle to img_name (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns img_name contents as cell array
%        contents{get(hObject,'Value')} returns selected item from img_name
selection = get(hObject,'Value');
dir=fileparts(mfilename('fullpath'));
switch selection
    case 1
        imname = [dir(1:end-3),'image/cameraman.tif'];
    case 2
        imname = [dir(1:end-3),'image/einstein.tif'];
    case 3
        bk=0;
        while ~bk
        imname = uigetfile({'*.jpg;*.jpeg;*.png;*.tif;';'*.*'},...
            'Load User Defined Image',...
            [dir(1:end-3),'image/coco.tif']);
        if isequal(imname,0)
            bk=0;
        else
            bk=1;
        end
        end
        imname = [dir(1:end-3),'image/',imname];
end
im = double(imread(imname));
N = size(im,1);
% crop a square image
im = im(1:N,1:N);
if N~=handles.N
    handles.N = N;
    [handles.psf,handles.psf0] =  convKernel(N,handles.ker,handles.bSize);
end
y = convolve2(im,handles.psf);
sigma = norm(y-mean(y(:)),'fro')/sqrt(N*N*10^(0.1*handles.bsnr));
randn('state',[362436069;521288629]);
noise = sigma.*randn(N,N);
blurred = convolve2(im,handles.psf) + noise;
deblurred = blurred;

SNRin = SNR( blurred, im );
SSIMin = ssim_index( blurred, im );

% update handles' fields
handles.n_eng = norm(noise,'fro')^2;
handles.img = im;
handles.N = N;
handles.blurred = blurred;
handles.deblurred = deblurred;
handles.SNRin = SNRin;
handles.SSIMin = SSIMin;

% show images
set(gcf,'CurrentAxes', handles.org_img);
imshow(uint8(handles.img));
set(handles.org_img_name,'String',...
    ['Original Image (',num2str(N),' x ',num2str(N),')']);
% title(['Original Image (',num2str(N),' x ',num2str(N),')']);
% ---------------------------------------
set(gcf,'CurrentAxes', handles.blur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.blur_img_name,'String',...
    ['Blurred Image (',num2str(N),' x ',num2str(N),')']);
% title(['Blurred Image (',num2str(N),' x ',num2str(N),')']);
% ---------------------------------------
set(gcf,'CurrentAxes', handles.deblur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.deblur_img_name,'String',...
    ['Deblurred Image (',num2str(N),' x ',num2str(N),')']);
% title(['Deblurred Image (',num2str(N),' x ',num2str(N),')']);
text('Position',[floor(handles.N/2),floor(handles.N/2)],...
    'String','{\bf Not Deblurred yet!}','HorizontalAlignment','center',...
    'Rotation',30,'Color','yellow','FontName','default',...
    'FontSize',16,'Interpreter','latex');
% ---------------------------------------
linkaxes([handles.org_img handles.blur_img handles.deblur_img]);

% update GUI displays
set(findobj('Tag','snr_in'),'String',[num2str(handles.SNRin,'%.2f'),' dB']);
set(findobj('Tag','ssim_in'),'String',num2str(handles.SSIMin,'%.2f'));
set(findobj('Tag','snr_out'),'String','---');
set(findobj('Tag','ssim_out'),'String','---');
set(findobj('Tag','time'),'String','---');

guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function img_name_CreateFcn(hObject, eventdata, handles)
% hObject    handle to img_name (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in blur_kernel.
function blur_kernel_Callback(hObject, eventdata, handles)
% hObject    handle to blur_kernel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns blur_kernel contents as cell array
%        contents{get(hObject,'Value')} returns selected item from blur_kernel
selection = get(hObject,'Value');
switch selection
    case 1
        handles.ker = 5;
        set(handles.text19,'Visible','on');
        set(handles.blur_size,'Visible','on');
    case 2
        handles.ker = 3;
        set(handles.text19,'Visible','off');
        set(handles.blur_size,'Visible','off');
    case 3
        handles.ker = 4;
        set(handles.text19,'Visible','off');
        set(handles.blur_size,'Visible','off');
end
[ handles.psf, handles.psf0 ] = convKernel( handles.N, handles.ker, handles.bSize);

y = convolve2(handles.img,handles.psf);
sigma = norm(y-mean(y(:)),'fro')/sqrt(handles.N*handles.N*10^(0.1*handles.bsnr));
randn('state',[362436069;521288629]);
noise = sigma.*randn(handles.N,handles.N);
blurred = convolve2(handles.img,handles.psf) + noise;
deblurred = blurred;

SNRin = SNR( blurred, handles.img );
SSIMin = ssim_index( blurred, handles.img );

% update handles' fields
handles.n_eng = norm(noise,'fro')^2;
handles.blurred = blurred;
handles.deblurred = deblurred;
handles.SNRin = SNRin;
handles.SSIMin = SSIMin;

% show images
set(gcf,'CurrentAxes', handles.blur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.blur_img_name,'String',...
    ['Blurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Blurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% ---------------------------------------
set(gcf,'CurrentAxes', handles.deblur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.deblur_img_name,'String',...
    ['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
text('Position',[floor(handles.N/2),floor(handles.N/2)],...
    'String','{\bf Not Deblurred yet!}','HorizontalAlignment','center',...
    'Rotation',30,'Color','yellow','FontName','default',...
    'FontSize',16,'Interpreter','latex');
% ---------------------------------------
linkaxes([handles.org_img handles.blur_img handles.deblur_img]);

% update GUI displays
set(findobj('Tag','snr_in'),'String',[num2str(handles.SNRin,'%.2f'),' dB']);
set(findobj('Tag','ssim_in'),'String',num2str(handles.SSIMin,'%.2f'));
set(findobj('Tag','snr_out'),'String','---');
set(findobj('Tag','ssim_out'),'String','---');
set(findobj('Tag','time'),'String','---');

guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function blur_kernel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to blur_kernel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function blur_size_Callback(hObject, eventdata, handles)
% hObject    handle to blur_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of blur_size as text
%        str2double(get(hObject,'String')) returns contents of blur_size as a double
handles.bSize=str2double(get(hObject,'String'));

[ handles.psf, handles.psf0 ] = convKernel( handles.N, handles.ker, handles.bSize);

y = convolve2(handles.img,handles.psf);
sigma = norm(y-mean(y(:)),'fro')/sqrt(handles.N*handles.N*10^(0.1*handles.bsnr));
randn('state',[362436069;521288629]);
noise = sigma.*randn(handles.N,handles.N);
blurred = convolve2(handles.img,handles.psf) + noise;
deblurred = blurred;

SNRin = SNR( blurred, handles.img );
SSIMin = ssim_index( blurred, handles.img );

% update handles' fields
handles.n_eng = norm(noise,'fro')^2;
handles.blurred = blurred;
handles.deblurred = deblurred;
handles.SNRin = SNRin;
handles.SSIMin = SSIMin;

% show images
set(gcf,'CurrentAxes', handles.blur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.blur_img_name,'String',...
    ['Blurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Blurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% ---------------------------------------
set(gcf,'CurrentAxes', handles.deblur_img);
imshow(uint8(imfilter(handles.img,handles.psf0,'replicate')+noise));
set(handles.deblur_img_name,'String',...
    ['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
% title(['Deblurred Image (',num2str(handles.N),' x ',num2str(handles.N),')']);
text('Position',[floor(handles.N/2),floor(handles.N/2)],...
    'String','{\bf Not Deblurred yet!}','HorizontalAlignment','center',...
    'Rotation',30,'Color','yellow','FontName','default',...
    'FontSize',16,'Interpreter','latex');
% ---------------------------------------
linkaxes([handles.org_img handles.blur_img handles.deblur_img]);

% update GUI displays
set(findobj('Tag','snr_in'),'String',[num2str(handles.SNRin,'%.2f'),' dB']);
set(findobj('Tag','ssim_in'),'String',num2str(handles.SSIMin,'%.2f'));
set(findobj('Tag','snr_out'),'String','---');
set(findobj('Tag','ssim_out'),'String','---');
set(findobj('Tag','time'),'String','---');

guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function blur_size_CreateFcn(hObject, eventdata, handles)
% hObject    handle to blur_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
