% Load a square image
I=double(imread('bank.TIFF'));
figure(1),image(I),colormap(gray(256)),axis image
set(gca,'fontsize',14)
title('Original image')
[M,~]=size(I);      % Should be a power of 2

% Choose a fractional spline wavelet transform
alpha=1.5;          % Real value larger than -0.5
tau=0.3;            % Real value between -0.5 and +0.5
type='ortho';       % Options are:  1. 'bspline'
                    %               2. 'ortho'
                    %               3. 'dual'
[FFTanalysisfilters,FFTsynthesisfilters]=FFTfractsplinefilters(M,alpha,tau,type);

% Perform a fractional spline wavelet transform of the image
J=3;                % Number of decomposition levels
W=FFTwaveletanalysis2D(I,FFTanalysisfilters,J);

% Show a subband
band='HH2';       
titletext=['Subband ' band(1:2) ' at depth ' band(3:end)];
b0=wextract2D(W,band);
figure(2),clf,imagesc(b0),colormap(gray(256)),axis image
set(gca,'fontsize',14)
title(titletext)

% Show the whole wavelet transform
show=1;             % show=1 shows the denomination of the wavelet subbands ('HL1', 'HH1', etc.)
                    % show=0 does not show these denominations
figure(3),clf,waveletplot2D(W,J,show)
set(gca,'fontsize',14)
title({['Fractional Spline Wavelet Transform (' num2str(J) ' levels)'],[ type '-type, alpha=' num2str(alpha) ', tau=' num2str(tau)]})

% Reconstruction of the image from its wavelet transform
I0=FFTwaveletsynthesis2D(W,FFTsynthesisfilters,J);
disp(['Resynthesis error: ' num2str(max(abs(I0(:)-I(:))))])

% Reconstruction from only one subband: use of the second output parameter
% from the function wextract2D.m
band='LL3';       
titletext=['Image resynthetized from subband ' band(1:2) ' at depth ' band(3:end)];
[b0,W0]=wextract2D(W,band);
I0=FFTwaveletsynthesis2D(W0,FFTsynthesisfilters,J);
figure(4),clf,image(I0),colormap(gray(256)),axis image
set(gca,'fontsize',14)
title(titletext)

% Plot of the synthesis scaling function and the wavelet
[x,y1]=fractsplinefunction(alpha,tau,type,10);
[x,y2]=fractsplinewaveletfunction(alpha,tau,type,10);
figure(5),plot(x,y1,'b',x,y2,'r')
set(gca,'fontsize',14)
legend('scaling function','wavelet')
title([type '-type, alpha=' num2str(alpha) ', tau=' num2str(tau)])