function e=MSE(I1,I2,opt)
% MSE: calculate mean-square-error
s1=size(I1);
s2=size(I2);
if s1~=s2
    error('Size of two images does not match');
elseif nargin>2
    I1=[I1(:),ones(numel(I1),1)];
    coef=(I1'*I1)\(I1'*I2(:));
    I1=I1*coef;
    e=(I1-I2(:))'*(I1-I2(:))/(s1(1)*s1(2));
else
    delta=(I1-I2).*(I1-I2);
    e=sum(delta(:))/(s1(1)*s1(2));
end