#include <iostream>
#include <string>
#include <fstream>
#include <string.h>
#include <stdlib.h>
using namespace std;

class mem_graph{

	public:

		int V;
		int E;
		int start_mode;//start vid

		int * start_out;
		int * out_size;
		int * out_edge;

		int * start_in;
		int * in_size;
		int * in_edge;

		mem_graph(int v, int e, int mode):V(v), E(e), start_mode(mode)
		{
			start_out = new int[V];
			out_size = new int[V];
			out_edge = new int[E];

			start_in = new int[V];
			in_size = new int[V];
			in_edge = new int[E];
		}

		~mem_graph()
		{
			delete start_out;
			delete out_size;
			delete out_edge;

			delete start_in;
			delete in_size;
			delete in_edge;
		}

		void load(string inputfile)
		{
			ifstream fin;
			fin.open(inputfile.c_str(), ios::in);
			if(!fin.is_open())
			{
				cerr<<"File does not exist !"<<endl;
				exit(-1);
			}
			int vid;
			int* current_outedge_index = out_edge;
			while(fin>>vid)
			{
				int num;
				fin>>num;
				int adjusted_id=vid-start_mode;
				out_size[adjusted_id]=num;
				for(int i=0; i<num; i++)
				{
					int tgt;
					fin>>tgt;
					*current_outedge_index = tgt;
					current_outedge_index++;
				}
				if(adjusted_id==0) start_out[adjusted_id]=0;
				else start_out[adjusted_id] = start_out[adjusted_id-1] + out_size[adjusted_id-1];
			}
			fin.close();
			//------------------------------

			//in_size array
			memset(in_size, 0, V*sizeof(int));
			for (int i = 0; i < E; i++) {
				in_size[out_edge[i] - start_mode]++;
			}

			//start_in array
			int cur = 0;
			for (int i = 0; i < V; i++) {
				start_in[i] = cur;
				cur += in_size[i];
			}

			//Initialize in_edge array properly
			int * offset = new int[V];
			memset(offset, 0, V*sizeof(int));
			for (int i = 0; i < V; i++) {
				int original_id = i + start_mode;
				int size = get_out_size(original_id);
				int* adj = get_out_adj(original_id);
				for (int j = 0; j < size; j++) {
					int v = adj[j];
					int start = start_in[v - start_mode];
					in_edge[start + offset[v - start_mode]] = original_id;
					offset[v - start_mode]++;
				}
			}
			delete offset;
		}

		//-1 means not initialized
		int get_out_size(int vid)
		{
			if (out_size) {
				return out_size[vid - start_mode];
			}else{
				return -1;
			}
		}

		int get_in_size(int vid)
		{
			if (in_size) {
				return in_size[vid - start_mode];
			}else{
				return -1;
			}
		}

		int * get_out_adj(int vid)
		{
			return out_edge + start_out[vid - start_mode];
		}

		int * get_in_adj(int vid)
		{
			return in_edge + start_in[vid - start_mode];
		}

};





