//
//  EAGLView.h
//  Week3WithText2D
//
//  Created by Ay on 2008/9/22.
//  Copyright NA 2008. All rights reserved.
//


#import <UIKit/UIKit.h>
#import <OpenGLES/EAGL.h>
#import <OpenGLES/ES1/gl.h>
#import <OpenGLES/ES1/glext.h>

#include "Texture2D.h"
/*
This class wraps the CAEAGLLayer from CoreAnimation into a convenient UIView subclass.
The view content is basically an EAGL surface you render your OpenGL scene into.
Note that setting the view non-opaque will only work if the EAGL surface has an alpha channel.
*/
@interface EAGLView : UIView {
	
@private
	/* The pixel dimensions of the backbuffer */
	GLint backingWidth;
	GLint backingHeight;
	
	EAGLContext *context;
	
	/* OpenGL names for the renderbuffer and framebuffers used to render to this view */
	GLuint viewRenderbuffer, viewFramebuffer;
	
	/* OpenGL name for the depth buffer that is attached to viewFramebuffer, if it exists (0 if it does not exist) */
	GLuint depthRenderbuffer;
	
	NSTimer *animationTimer;
	NSTimeInterval animationInterval;
	
	
	/**********Added By Ay************/
	Texture2D* bg;
	Texture2D* spriteFront;
	Texture2D* spriteBack;
	
	int gameCount;
	int showStatus[3][3][3];
	int scores;
	/*********************************/
}

@property NSTimeInterval animationInterval;
@property int scores;

- (void)startAnimation;
- (void)stopAnimation;
- (void)drawView;

@end
