#include <stdio.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netdb.h>
#include <string.h>


#include "sml.h"



int main(int argc, char *argv[]){
	int I=1, P=5, B=1, bit_length=1024;
	int err, i, j;
	SML_SESSION session;
	SML_SESSION *client_session;
	char *packet = (char*)malloc(1400);
	FILE *fp;
	SML_SIGNATURE signature;

	if (argc > 1) bit_length = atoi(argv[1]);
	if (argc > 2) I = atoi(argv[2]);
	if (argc > 3) P = atoi(argv[3]);
	if (argc > 4) B = atoi(argv[4]);

	// init session
    SML_InitSession(&session);

	// new key pair
    SML_NewKeyPair(&session, 512, RSA_DEFAULT_PUBLIC_EXPONENT, CRYPTO_KEY_RSA);

    // wait for client
    fprintf(stderr, "Server waiting for client...");
    client_session = SML_Accept(&session, SML_SERVER_PORT, "keys/keys.list");
    if (client_session == NULL) {
        fprintf(stderr, "failed!\n");
        return -1;
    }
    fprintf(stderr, "accepted!\n");
    
    SML_LoadRpsSetting(client_session, "session-000.dat", "dummy_passwd");
    //SML_SaveRpsSetting(client_session, "session-000.dat", "dummy_passwd");
    SML_SendRpsSetting(client_session);

    // create packets with random content
    srand(time(NULL));
    fprintf(stderr, "send packet");
    fp = fopen("dummy1.txt", "wt");
    for (i=0; i<100; i++) {
    	for (j=0; j<1400-1; j++) {
    		packet[i] = rand() % 127;
    	}
    	packet[1400-1] = '\0';
    	fwrite(packet, 1400, 1, fp);
    	
    	SML_TcpSendEncryptRps(client_session, packet,1400);
    	fprintf(stderr, ".");
    }
    fclose(fp);
    fprintf(stderr, "OK!\n");

    SML_DestroySession(client_session);
    

    // wait for client
    fprintf(stderr, "Server waiting for client...");
    client_session = SML_Accept(&session, SML_SERVER_PORT, "keys/keys.list");
    if (client_session == NULL) {
        fprintf(stderr, "failed!\n");
        return -1;
    }
    fprintf(stderr, "accepted!\n");

    //SML_InitRps(client_session, I, P, B, 1400, SML_RPS_MULTI_KEY_RSA, bit_length);
    SML_LoadRpsSetting(client_session, "session-000.dat", "dummy_passwd");
    SML_SendRpsSetting(client_session);


    SML_DestroySession(&session);
	
	return 0;
}
