#include <stdio.h>
#include <stdlib.h>



#include "crypto.h"
#include "rsa.h"
#include "mkrsa.h"



const char data[] =
"In the beginning God created the heavens and the earth." 
"Now the earth was formless and empty. Darkness was on the surface of the deep. God's Spirit was hovering over the"
"surface of the waters. "
"God said, Let there be light, and there was light." 
"God saw the light, and saw that it was good. God divided the light from the darkness." 
"God called the light Day, and the darkness he called Night. There was evening and there was morning, one day. "
"God said, Let there be an expanse in the midst of the waters, and let it divide the waters from the waters. "
"God made the expanse, and divided the waters which were under the expanse from the waters which were above the"
"expanse, and it was so. "
"God called the expanse sky. There was evening and there was morning, a second day. "
"God said, Let the waters under the sky be gathered together to one place, and let the dry land appear, and it was so. "
"God called the dry land Earth, and the gathering together of the waters he called Seas. God saw that it was good. "
"God said, Let the earth put forth grass, herbs yielding seed, and fruit trees bearing fruit after their kind, with its seed in"
"it, on the earth, and it was so. ";

int key_test1(void)
{
	CRYPTO_KEY_PAIR key, key2;
	char *cipher, *plaintext, *str = NULL, *str2 = NULL;
	int  cipher_len, data_len, plaintext_len, err;

	// create a new key pair
	CRYPTO_InitKeyPair(&key);
	CRYPTO_NewKeyPair(&key, 512, RSA_DEFAULT_PUBLIC_EXPONENT, CRYPTO_KEY_RSA);
	CRYPTO_SaveKeyPair(key, "rsa_test.rsa", "dummy_passwd");

	data_len = CRYPTO_KeyToStringAlloc(&str, key.public_key);
	fprintf(stderr, "rsa_test, key 1 = \n%s\n\n", str);

	// allocate memory for encryption and decryption	
	cipher_len = data_len * 2;
	plaintext_len = data_len * 2;

	cipher = (char*)malloc(sizeof(char) * cipher_len);
	plaintext = (char*)malloc(sizeof(char) * plaintext_len);
	if (cipher == NULL || plaintext == NULL) {
		fprintf(stderr, "Not enough memory!\n");
		return -1;
	}
	
	// encrypt it
	err = RSA_SignPublicKey(cipher, &cipher_len, key);
	if (err == 0) {
		fprintf(stderr, "Cipher buffer not big enough!\n");
		return -1;
	}
	
	// decrypt it
	err = RSA_CheckSignedPublicKey(cipher, cipher_len, key.public_key);
	if (err == 0) {
		//fprintf(stderr, "Plaintext buffer not big enough!\n");
		fprintf(stderr, "check key failed\n");
		return -1;
	}
	else {
		fprintf(stderr, "check key okay\n");
	}
	
	/*
	// form a new key pair from the decrypted string
	CRYPTO_InitKeyPair(&key2);
	CRYPTO_ParseKeyFromString(&key2.public_key, plaintext);
	CRYPTO_KeyToStringAlloc(&str2, key2.public_key);

	fprintf(stderr, "rsa_test, key 2 = \n%s\n\n", str2);
	*/

	// release memory
	free(str);
	free(str2);	
	free(cipher);
	free(plaintext);
	
	CRYPTO_DestroyKeyPair(&key);
	//CRYPTO_DestroyKeyPair(&key2);
}


int key_test2(void)
{
	int i;
	char name[5][10] = {"yeungsiu", "alix", "john", "tai", "patrick"};
	char filename[5][20] = {"keys/yeungsiu.rsa", "keys/alix.rsa", "keys/john.rsa", "keys/tai.rsa", "keys/patrick.rsa"};
	CRYPTO_KEY_PAIR pair;

	// create a new key pair
	CRYPTO_InitKeyPair(&pair);

	// generate a number of random keys
	for (i=0; i<5; i++) {
		CRYPTO_NewKeyPair(&pair, 512, RSA_DEFAULT_PUBLIC_EXPONENT, CRYPTO_KEY_RSA);
		CRYPTO_SaveKeyPair(pair, filename[i], "dummy_passwd");
		CRYPTO_AddKeyToListFile(pair.public_key, name[i], "keys/keys.list");

		fprintf(stderr, "key generated: %d\n", i);
		usleep(1000000);
	}

	// release resource
	CRYPTO_DestroyKeyPair(&pair);
	
	return 0;
}

int key_test3(void)
{
	CRYPTO_KEY_PAIR pair;
	char user[1024];
	
	CRYPTO_InitKeyPair(&pair);
	CRYPTO_LoadKeyPair(&pair, "keys/rsa_test.rsa", "dummy_passwd", CRYPTO_KEY_RSA);
	
	if (CRYPTO_QueryUserFromListFile(user, 1024, pair.public_key, "keys/keys.list")) {
		fprintf(stderr, "key exists in list: %s\n\n", user);
	}
	else {
		fprintf(stderr, "key not exists in list!\n\n");
	}
	
	CRYPTO_DestroyKeyPair(&pair);
	
	return 0;
}

void key_test4()
{
	MKRSA_KEY_PAIR pair1, pair2, pair3;
	char *cipher3, *cipher2, *cipher, *plaintext;
	int cipher_len = 4096;
	int plaintext_len = 4096;

	cipher3 = (char*) malloc(sizeof(char)*cipher_len);
	cipher2 = (char*) malloc(sizeof(char)*cipher_len);
	cipher = (char*) malloc(sizeof(char)*cipher_len);
	plaintext = (char*) malloc(sizeof(char)*cipher_len);

	CRYPTO_InitKeyPair(&pair1);
	CRYPTO_InitKeyPair(&pair2);
	CRYPTO_InitKeyPair(&pair3);

	MKRSA_NewKeyPair(&pair1, 512, MKRSA_RANDOM_PUBLIC_EXPONENT);
	MKRSA_Encrypt(cipher, &cipher_len, (char*)data, strlen(data), pair1.private_key);

	MKRSA_NewReEncryptionKeyPair(&pair2, pair1.private_key);
	MKRSA_ReEncrypt(cipher2, &cipher_len, cipher, cipher_len, pair2.private_key);
	
	MKRSA_NewReEncryptionKeyPair(&pair3, pair1.private_key);
	MKRSA_ReEncrypt(cipher3, &cipher_len, cipher, cipher_len, pair3.private_key);

	MKRSA_Decrypt(plaintext, &plaintext_len, cipher3, cipher_len, pair3.public_key);

	fprintf(stderr, "input:\n%s\n\n", data);
	fprintf(stderr, "output:\n%s\n\n", plaintext);

	CRYPTO_DestroyKeyPair(&pair1);
	CRYPTO_DestroyKeyPair(&pair2);
	CRYPTO_DestroyKeyPair(&pair3);
}


int main(void)
{	
	key_test4();
	
	return 0;
}

