#ifndef __RSA_HEADER_INCLUDED__
#define __RSA_HEADER_INCLUDED__



#include "crypto.h"


extern gmp_randstate_t rand_state;


#define RSA_MAX_KEY_STRING_LEN 4096

//////////////////////////////////////////////////////////////
// public key exponent used for key generation
#define RSA_DEFAULT_PUBLIC_EXPONENT 65537
#define RSA_RANDOM_PUBLIC_EXPONENT 0


//////////////////////////////////////////////////////////////
// mapping of each key parameter to key struct's array element
#define RSA_NUM_PARAM 2

#define RSA_PARAM_EXPONENT         0
#define RSA_PARAM_MODULUS          1


//////////////////////////////////////////////////////////////
// key type definition
typedef CRYPTO_KEY RSA_KEY;
typedef CRYPTO_KEY RSA_PUBLIC_KEY;
typedef CRYPTO_KEY RSA_PRIVATE_KEY;

typedef CRYPTO_KEY_PAIR RSA_KEY_PAIR;


//////////////////////////////////////////////////////////////
// RSA function prototypes
void __RSA_GenerateRandomParameters(unsigned int bit_length, mpz_t mod, mpz_t phi);
void __RSA_GeneratePrivateExp(unsigned int bit_length, mpz_t pri_exp, mpz_t pub_exp, mpz_t phi);

BOOL RSA_NewKeyPair(RSA_KEY_PAIR *key_pair, unsigned int bit_length, unsigned long pub_exp_int);
BOOL RSA_LoadKeyPair(RSA_KEY_PAIR *key_pair, char key_filename[], char passwd[]);
BOOL RSA_SaveKeyPair(RSA_KEY_PAIR key_pair, char key_filename[], char passwd[]);

void __RSA_Encrypt(mpz_t cipher, mpz_t data, RSA_KEY key);
void __RSA_Decrypt(mpz_t data, mpz_t cipher, RSA_KEY key);
void __RSA_PublicEncrypt(mpz_t cipher, mpz_t data, RSA_KEY_PAIR key_pair);
void __RSA_PublicDecrypt(mpz_t data, mpz_t cipher, RSA_KEY_PAIR key_pair);
void __RSA_PrivateEncrypt(mpz_t cipher, mpz_t data, RSA_KEY_PAIR key_pair);
void __RSA_PrivateDecrypt(mpz_t data, mpz_t cipher, RSA_KEY_PAIR key_pair);

BOOL RSA_Encrypt(char cipher[], int *out_len, char data[], int in_len, RSA_KEY key);
BOOL RSA_Decrypt(char data[], int *out_len, char cipher[], int in_len, RSA_KEY key);
BOOL RSA_PublicEncrypt(char cipher[], int *out_len, char data[], int in_len, RSA_KEY_PAIR key_pair);
BOOL RSA_PublicDecrypt(char data[], int *out_len, char cipher[], int in_len, RSA_KEY_PAIR key_pair);
BOOL RSA_PrivateEncrypt(char cipher[], int *out_len, char data[], int in_len, RSA_KEY_PAIR key_pair);
BOOL RSA_PrivateDecrypt(char data[], int *out_len, char cipher[], int in_len, RSA_KEY_PAIR key_pair);

BOOL RSA_SignPublicKey(char cipher[], int *out_len, RSA_KEY_PAIR pair);
BOOL RSA_CheckSignedPublicKey(char cipher[], int in_len, RSA_KEY key);

unsigned int RSA_GetPlaintextUnitSize(RSA_KEY key);
unsigned int RSA_GetCipherUnitSize(RSA_KEY key);

#endif /* __RSA_HEADER_INCLUDED__ */
