#include <stdio.h>
#include <string.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netdb.h>


#include "sml.h"


int main(int argc, char *argv[]) {
	int err, i, size;
    SML_SESSION session, server_session, *client_session;
    SML_SIGNATURE signature;
    RPS rps;
    char *packet;
    FILE *fp;

	////////////////////////////////////////////////////////////////////////
	// check command line arguments
	if (argc != 2) {
		perror("ERROR: Usage: proxy [server_ip]\n");
		return -1;
	}

	////////////////////////////////////////////////////////////////////////
    // connect to server and cache data
    SML_InitSession(&server_session);
    fprintf(stderr, "Connecting server......");

    err = SML_Connect(&server_session, argv[1], SML_SERVER_PORT);
    if (err == FALSE) {
        fprintf(stderr, "failed!\n");
        return -1;
    }
    fprintf(stderr, "ok.\nCaching packets");

    SML_ReceiveRpsSetting(&server_session);
    
    // receive the packets
    size = SML_GetRpsEncryptedPacketSize(&server_session);
    packet = (char*)malloc(size);
    fp = fopen("cache.txt", "wt");
    for (i=0; i<100; i++) {
    	SML_TcpReceiveRps(&server_session, packet, size);
    	fwrite(packet, size, 1, fp);
    	fprintf(stderr, ".");
    }
    fclose(fp);
    fprintf(stderr, "ok.\n");

    SML_DestroySession(&server_session);

	////////////////////////////////////////////////////////////////////////
    // wait for client
    SML_InitSession(&session);

    fprintf(stderr, "Proxy wait for client......");
    client_session = SML_Accept(&session, SML_PROXY_PORT, NULL);
    if (client_session == NULL) {
        fprintf(stderr, "failed!\n");
        return -1;
    }
    fprintf(stderr, "accepted.\nConnect to server uning client's public key......");

    SML_InitSession(&server_session);
    SML_InitSignature(&signature);
    SML_GetClientSignature(client_session, &signature);
    SML_SetClientSignature(&server_session, signature);
    SML_DestroySignature(&signature);

    err = SML_Connect(&server_session, argv[1], SML_SERVER_PORT);
    if (err == FALSE) {
        fprintf(stderr, "failed!\n");
        return -1;
    }
    fprintf(stderr, "ok.\n");

	////////////////////////////////////////////////////////////////////////
    // re-encrypt packets to client
    SML_ReceiveRpsSetting(&server_session);
    RPS_Init(&rps);
    SML_GetRpsSetting(&server_session, &rps);
    SML_SetRpsSetting(client_session, rps);
    RPS_Destroy(&rps);
    SML_SendRpsSetting(client_session);
    
    SML_DestroySession(&server_session);

	fprintf(stderr, "Proxy re-encrypt to client");
    fp = fopen("cache.txt", "rt");
    for (i=0; i<100; i++) {
    	fread(packet, size, 1, fp);
    	SML_TcpSendReEncryptRps(client_session, packet, size);
    	fprintf(stderr, ".");
    }
    fclose(fp);
    fprintf(stderr, "ok.\n");

    return 0;
}
