#include <stdio.h>
#include <string.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netdb.h>


#include "sml.h"


int main(int argc, char *argv[]) {
	int err, i, port;
    SML_SESSION session;
    char *packet = (char*)malloc(1400);
    FILE *fp;

	// check command line arguments
	if (argc < 2) {
		perror("ERROR: Usage: client [host] [port]\n");
		return -1;
	}

	if (argc < 3) {
		port = SML_SERVER_PORT;
	}
	else {
		port = atoi(argv[2]);
	}

	// init session
    SML_InitSession(&session);

    // load key pair
    SML_LoadKeyPair(&session, "keys/alix.rsa", "dummy_passwd", CRYPTO_KEY_RSA);

    // connect to server
    err = SML_Connect(&session, argv[1], port);
    if (err == FALSE) {
        fprintf(stderr, "SML_Connect Failed: %d\n", err);
        return -1;
    }

    SML_ReceiveRpsSetting(&session);

	// receive the packets
    fprintf(stderr, "receive packet");
    fp = fopen("dummy2.txt", "wt");
    for (i=0; i<100; i++) {    	
    	SML_TcpReceiveDecryptRps(&session, packet, 1400);
    	fwrite(packet, 1400, 1, fp);
    	fprintf(stderr, ".");
    }
    fclose(fp);
    fprintf(stderr, "OK!\n", packet);
	
    // release all resource before exit
    SML_DestroySession(&session);
    
    return 0;
}
